choose.compound <-
function(x, type="positive", criteria="AIC")
{
comp1.seq=c("EXP","EXP2","MO","SB")
comp2.seq=c("EXP","EXP2","MO","SB")
use=3
if(criteria=="BIC"){use=4}
if(type=="positive"){dist.seq=c("exp","gamma","lnorm","lomax","bisa")
if(any(x<=0)) stop("x should be positive")}
if(type=="unit"){dist.seq=c("beta","kumar")
if(any(x<=0) | any(x>=1)) stop("x should be between 0 and 1")}
if(type=="real"){dist.seq=c("norm","logis","cauchy","gumbel")}
fit<-c();h=1;models=c()
for(hh in 1:length(dist.seq))
{
fit[h]=estimate.compound(x, dist=dist.seq[hh], comp1=as.null(), comp2=as.null(),est.var=FALSE)[[use]]
h=h+1
models=rbind(models,c(dist.seq[hh],"",""))
for(ii in 1:length(comp1.seq))
{
fit[h]=estimate.compound(x, dist=dist.seq[hh], comp1=comp1.seq[ii], comp2=as.null(),est.var=FALSE)[[use]]
h=h+1
models=rbind(models,c(dist.seq[hh],comp1.seq[ii],""))
for(jj in 1:length(comp2.seq))
{
if(ii!=jj)
{
fit[h]=estimate.compound(x, dist=dist.seq[hh], comp1=comp1.seq[ii], comp2=comp2.seq[jj],est.var=FALSE)[[use]]
h=h+1
models=rbind(models,c(dist.seq[hh],comp1.seq[ii],comp2.seq[jj]))
}
}
}
}
sfit <- sort(fit);ind=c()
for(i in 1:length(sfit)) ind[i]=which(fit==sfit[i])
param<-4-ifelse(models[,1]=="exp",1,0)-ifelse(models[,2]=="",1,0)-ifelse(models[,3]=="",1,0)
resu<-data.frame(models,round(fit,2),param)[ind,]
rownames(resu)<-1:nrow(resu)
colnames(resu)<-c("baseline","G1","G2",criteria,"parameters")
comp1.final=resu[1,2]
comp2.final=resu[1,3]
if(resu[1,2]=="") comp1.final=as.null()
if(resu[1,3]=="") comp2.final=as.null()
final<-estimate.compound(x, dist=resu[1,1], comp1=comp1.final, comp2=comp2.final,est.var=TRUE)
list(summary=resu, selected=final, dist=resu[1,1], comp1=comp1.final, comp2=comp2.final)
}
