% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{w3w}
\alias{w3w}
\title{What 3 Words wrapper}
\usage{
w3w(x)
}
\arguments{
\item{x}{A vector, or list, of words. Strings with dots in them will be split.
After splitting, there must be a multiple of three words.
Either a vector of words, for a single latitude/longitude pair, or
a list of vectors for vectorised operations. This wrapper also accepts a
single string of three words separated by full stops.}
}
\value{
a numeric vector of length 2, consisting of lat(itude) and lon(gitude)
}
\description{
This function requires you to have a valid what3words API key called
\code{W3WAPIKey} stored as an environment variable
}
\examples{
\dontrun{
w3w("president.always.lying")
w3w("unseen.academicals.football") ## returns NAs
w3w(list("special.tools.required", "cliffs.falling.rocks",
         "available.during.winter", "ultraviolet.light.required"))
w3w(c("protests", "memo", "consoles"))
}
}
