% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocd_vector.R
\name{geocd_vector}
\alias{geocd_vector}
\title{geocomplexity for spatial vector data based on spatial dependence}
\usage{
geocd_vector(
  sfj,
  wt = NULL,
  method = "moran",
  normalize = TRUE,
  returnsf = TRUE
)
}
\arguments{
\item{sfj}{An \code{sf} object or spatial vector object that can be converted to \code{sf} by \code{sf::st_as_sf()}.}

\item{wt}{(optional) Spatial weight matrix. Must be a \code{matrix} class.}

\item{method}{(optional) In instances where the method is \code{moran}, geocomplexity is
determined using local moran measure method. Conversely, when the method is \code{spvar},
the spatial variance of attribute data serves to characterize geocomplexity. For all
other methods, the shannon information entropy of attribute data is employed to represent
geocomplexity. The selection of the method can be made from any one of the three options:
\code{moran}, \code{spvar} or \code{entropy}. Default is \code{moran}.}

\item{normalize}{(optional) Whether to further normalizes the calculated geocomplexity.
Default is \code{TRUE}.}

\item{returnsf}{(optional) When \code{returnsf} is \code{TRUE}, return an sf object, otherwise a tibble.
Default is \code{TRUE}.}
}
\value{
A \code{tibble} (\code{returnsf} is \code{FALSE}) or an \code{sf} object (\code{returnsf} is \code{TRUE})
}
\description{
This function calculates geocomplexity for spatial vector data based on spatial dependence.
}
\note{
If \code{wt} is not provided, for polygon vector data, \code{geocomplexity} will use a first-order queen
adjacency binary matrix; for point vector data, the six nearest points are used as adjacency
objects to generate an adjacency binary matrix.
}
\examples{
econineq = sf::read_sf(system.file('extdata/econineq.gpkg',package = 'geocomplexity'))
gc = geocd_vector(econineq)
gc

library(ggplot2)
library(viridis)
ggplot(gc) +
   geom_sf(aes(fill = GC_Gini)) +
   scale_fill_viridis(option = "mako", direction = -1) +
   theme_bw()

}
