% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolevel.R
\name{complete_point_geometry}
\alias{complete_point_geometry}
\alias{complete_point_geometry.geolevel}
\title{Complete point geometry}
\usage{
complete_point_geometry(gl)

\method{complete_point_geometry}{geolevel}(gl)
}
\arguments{
\item{gl}{A \code{geolevel} object.}
}
\value{
A \code{geolevel} object.
}
\description{
In case of having the polygon geometry defined, it obtains the point geometry
from it.
}
\details{
If the point geometry was already defined, if there are instances with this
geometry empty, it completes them.
}
\examples{

layer_us_state <- get_level_layer(gd_us, "state")

state <-
  geolevel(name = "state",
           layer = layer_us_state,
           key = "statefp",
           snake_case = TRUE) |>
  complete_point_geometry()

}
\seealso{
\code{\link{geodimension}}, \code{\link{relate_levels}}

Other geolevel definition functions: 
\code{\link{add_geometry}()},
\code{\link{check_key}()},
\code{\link{coordinates_to_geometry}()},
\code{\link{geolevel}()},
\code{\link{get_empty_geometry_instances}()},
\code{\link{get_geometry}()}
}
\concept{geolevel definition functions}
