% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explotation.R
\name{get_higher_level_names}
\alias{get_higher_level_names}
\alias{get_higher_level_names.geodimension}
\title{Get higher level names}
\usage{
get_higher_level_names(gd, level_name, indirect_levels)

\method{get_higher_level_names}{geodimension}(gd, level_name = NULL, indirect_levels = FALSE)
}
\arguments{
\item{gd}{A \code{geodimension} object.}

\item{level_name}{A string.}

\item{indirect_levels}{A boolean.}
}
\value{
A vector of names.
}
\description{
Get the names of levels included in the \code{geodimension} that are related to the
given level and are upper levels. We can get only the direct levels or the
levels reached by passing through other levels.
}
\examples{

ln_1 <- gd_us |>
  get_higher_level_names(level_name = "place")

ln_2 <- gd_us |>
  get_higher_level_names(level_name = "place", indirect_levels = TRUE)

}
\seealso{
\code{\link{geodimension}}, \code{\link{geolevel}}

Other information gathering functions: 
\code{\link{get_level_data_geo}()},
\code{\link{get_level_data}()},
\code{\link{get_level_geometries}()},
\code{\link{get_level_layer}()},
\code{\link{get_level_names}()}
}
\concept{information gathering functions}
