% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relations.R
\name{relate_levels}
\alias{relate_levels}
\alias{relate_levels.geodimension}
\title{Relate levels in a dimension}
\usage{
relate_levels(
  gd,
  lower_level_name,
  lower_level_attributes,
  upper_level_name,
  upper_level_key,
  by_geography
)

\method{relate_levels}{geodimension}(
  gd,
  lower_level_name = NULL,
  lower_level_attributes = NULL,
  upper_level_name = NULL,
  upper_level_key = NULL,
  by_geography = FALSE
)
}
\arguments{
\item{gd}{A \code{geodimension} object.}

\item{lower_level_name}{A string, name of the lower level.}

\item{lower_level_attributes}{A vector of attribute names.}

\item{upper_level_name}{A string, name of the upper lever.}

\item{upper_level_key}{A vector of attribute names.}

\item{by_geography}{A boolean.}
}
\value{
A \code{geodimension}.
}
\description{
Definition of a direct relationship between two levels of the dimension: the
lower level composes the higher level.
}
\details{
The relationship may exist by having attributes with common values or by
their geographic attributes. In the latter case, the geometry of the upper
level must be of the polygon type.

If no top-level attributes are indicated, the attributes that make up the key
are considered by default, only the corresponding attributes of the lower
level have to be indicated.

To use the geometric relationship, it must be explicitly indicated by the
Boolean parameter. In this case, the attributes of the lower level must not
exist in the table, they will be added with the values of the key of the upper
level, according to the established relationship. If lower level attribute names
are not provided, they will be generated from the upper level key names, adding
a prefix.
}
\examples{

layer_us_place <- gd_us |>
  get_level_layer("place")

layer_us_county <-
  dplyr::inner_join(
    get_level_data_geo(gd_us, "county"),
    get_level_layer(gd_us, "county"),
    by = c("geoid", "statefp", "name", "type")
  ) |>
  sf::st_as_sf()

place <-
  geolevel(name = "place",
           layer = layer_us_place,
           attributes = c("statefp", "county_geoid", "name", "type"),
           key = "geoid")

county <-
  geolevel(
    name = "county",
    layer = layer_us_county,
    attributes = c("statefp", "name", "type"),
    key = "geoid"
  ) |>
  add_geometry(coordinates_to_geometry(layer_us_county,
                                       lon_lat = c("intptlon", "intptlat")))

gd <-
  geodimension(name = "gd_us",
               level = place) |>
  add_level(level = county)

gd <- gd |>
  relate_levels(
    lower_level_name = "place",
    lower_level_attributes = "county_geoid",
    upper_level_name = "county"
  )

gd_2 <- gd |>
  relate_levels(
    lower_level_name = "place",
    upper_level_name = "county",
    by_geography = TRUE
  )

}
\seealso{
\code{\link{geodimension}}, \code{\link{geolevel}}

Other relationship between geolevels: 
\code{\link{complete_relation_by_geography}()},
\code{\link{get_unrelated_instances}()},
\code{\link{select_levels}()}
}
\concept{relationship between geolevels}
