% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{ssk}
\alias{ssk}
\title{Calculates the Skewness of Raster Values}
\usage{
ssk(x, adj = TRUE)
}
\arguments{
\item{x}{A raster or matrix.}

\item{adj}{Logical, defaults to \code{TRUE}. If \code{TRUE},
the adjusted Fisher-Pearson coefficient of skewness
is calculated. Otherwise, the standard coefficient is
calculated.}
}
\value{
A numeric value representing skewness.
# import raster image
data(normforest)
normforest <- terra::unwrap(normforest)

# find the adjusted coefficient of skewness
Ssk <- ssk(normforest, adj = TRUE)
}
\description{
Finds the Fisher-Pearson coefficient of skewness
for raster or matrix values (Ssk). Skewness represents the
asymmetry of the surface height distribution.
Height is measured as the value of a raster/matrix and
may not necessarily represent actual height.
}
