% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs_5yr_selection.R
\name{get_available_area_years}
\alias{get_available_area_years}
\alias{get_available_area_years.acs_5yr}
\title{Get available area years}
\usage{
get_available_area_years(ac, area)

\method{get_available_area_years}{acs_5yr}(ac, area)
}
\arguments{
\item{ac}{An \code{acs_5yr} object.}

\item{area}{A string, area name.}
}
\value{
A vector, area years.
}
\description{
Gets the years of the Demographic and Economic Areas that are downloaded and
unzipped, available to be queried.
}
\examples{

dir <- tempdir()
source_dir <- system.file("extdata/acs_5yr", package = "geogenr")
files <- list.files(source_dir, "*.zip", full.names = TRUE)
file.copy(from = files, to = dir, overwrite = TRUE)
ac <- acs_5yr(dir)

files <- ac |>
  unzip_files()

years <- ac |>
  get_available_area_years(area = "Alaska Native Regional Corporation")

}
\seealso{
Other data selection functions: 
\code{\link{as_acs_5yr_topic}()},
\code{\link{get_available_area_topics}()},
\code{\link{get_available_areas}()},
\code{\link{get_geo_attribute_names}()},
\code{\link{get_geo_layer.acs_5yr_geo}()},
\code{\link{get_names_of_other_topics}()},
\code{\link{get_report_names}()},
\code{\link{get_subreport_names}()},
\code{\link{get_topic_name}()},
\code{\link{select_report}()},
\code{\link{select_subreport}()},
\code{\link{select_topic}()}
}
\concept{data selection functions}
