% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{colourplot}
\alias{colourplot}
\title{colour plot}
\usage{
colourplot(
  x,
  y,
  z,
  X,
  Y,
  Z,
  nlevels = 20,
  colspec = hcl.colors,
  pch = 21,
  cex = 1,
  plot.title,
  plot.axes,
  key.title,
  key.axes,
  asp = NA,
  xaxs = "i",
  yaxs = "i",
  las = 1,
  axes = TRUE,
  frame.plot = axes,
  extra,
  ...
)
}
\arguments{
\item{x}{numerical vector of \eqn{n} equally spaced values to be
used in the contour plot.}

\item{y}{numerical vector of \eqn{m} equally spaced values to be
used in the contour plot.}

\item{z}{an \eqn{n \times m} matrix of numerical values to be used
in the contour plot.}

\item{X}{numerical vector of \eqn{N} values to be used in the
scatter plot.}

\item{Y}{numerical vector of \eqn{N} values to be used in the
scatter plot.}

\item{Z}{numerical vector of \eqn{N} values to be used in the
scatter plot.}

\item{nlevels}{number of levels to be used in the contour plot.}

\item{colspec}{colour specification (e.g., \code{rainbow},
\code{grey.colors}, \code{heat.colors}, \code{topo.colors}).}

\item{pch}{plot character (\code{21} -- \code{25}).}

\item{cex}{plot character magnification.}

\item{plot.title}{statements that add titles to the main plot.}

\item{plot.axes}{statements that draw axes on the main plot. This
overrides the default axes.}

\item{key.title}{statements that add titles for the plot key.}

\item{key.axes}{statements that draw axes on the plot key.  This
overrides the default axis.}

\item{asp}{the y/x aspect ratio, see \code{plot.window}.}

\item{xaxs}{the x axis style.  The default is to use internal
labelling.}

\item{yaxs}{the y axis style.  The default is to use internal
labelling.}

\item{las}{the style of labelling to be used.  The default is to
use horizontal labelling.}

\item{axes}{logicals indicating if axes should be drawn.}

\item{frame.plot}{logicals indicating if a box should be drawn, as
in \code{plot.default}.}

\item{extra}{(optional) extra intructions to be carried out in the
main plot window, such as text annotations.}

\item{...}{additional graphical parameters}
}
\value{
no return value
}
\description{
Adds a colour bar to a scatter plot and/or filled
    contour plot.  This function, which is based on base \code{R}'s
    \code{filled.contour} function, is useful for visualising
    kriging results.
}
\examples{
data('meuse',package='geostats')
colourplot(X=meuse$x,Y=meuse$y,Z=log(meuse$zinc),
           plot.title=title(main='Meuse',xlab='Easting',ylab='Northing'),
           key.title=title(main='log(Zn)'))
}
