% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{exp}
\alias{exp}
\alias{exp.density}
\title{exponential transformation}
\usage{
\method{exp}{density}(x)
}
\arguments{
\item{x}{an object of class \code{density}}
}
\value{
an object of class \code{density}
}
\description{
Map a logged kernel density estimate from [\eqn{-\infty,+\infty}]
to [\eqn{0,\infty}] by taking exponents.
}
\examples{
data(catchments,package='geostats')
lc <- log(catchments$CaMg)
ld <- density(lc)
d <- exp(ld)
plot(d)
}
