% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_functions.R
\name{set_assess_time}
\alias{set_assess_time}
\title{Adjusts assessment time for simulations}
\usage{
set_assess_time(
  data,
  time,
  output_type = c("input", "matrix", "list"),
  detailed_output = TRUE,
  Time = "Time",
  Event = "Censored",
  censoringOne = TRUE,
  Iter = "Iter"
)
}
\arguments{
\item{data}{Output file from simulate_trials() or simulate_trials_strata() created with detailed_output=TRUE, in either "list" or "matrix" format. Only these formats are supported.}

\item{time}{Positive number specifying the required assessment time.}

\item{output_type}{Choice of "input" (output in same format as input),"matrix" (matrix format output) or "list" (list format output). Default="input".}

\item{detailed_output}{Boolean to require full details of timings of competing processes. If FALSE, the simplified data only includes the *'ed output columns - this approximately halves RAM requirements. Default=TRUE (detailed).}

\item{Time}{String specifying the name of the time column. Default="Time"}

\item{Event}{String specifying the name of the censoring/event column. Default="Censored" (and by default it is a censoring column unless censoringOne=FALSE)}

\item{censoringOne}{Boolean specifying whether censoring is denoted in the censoring/event column by a one (TRUE) or zero (FALSE). Default=TRUE (censorings denoted by 1, events by 0)}

\item{Iter}{String specifying the name of the iterations column. Default="Iter"}
}
\value{
Returns the input simulated trial, in either matrix or list format, with modified assessment times. All columns dependent on this are also updated.
}
\description{
Function for modifying the assessment time of simulate_trials() or simulate_trials_strata() simulations.\cr
It is set up to automatically read in either matrix or list formats from simulate_trials() or simulate_trials_strata(), and only these inputs are supported.\cr
Note that if recruitment had not finished in the input then any increases in assessment time cannot account for the missing patients.
It is therefore strongly recommended to initially simulate for at least the duration of the recruitment before reducing the number to missing patients.\cr
This function can also be used to change format and/or slim down data for time-driven simulations.\cr
}
\examples{
example_sim <- simulate_trials(active_ecurve=Weibull(250,0.8),control_ecurve=Weibull(100,1),
rcurve=LinearR(12,100,100), assess=20, iterations=5,seed=12345,detailed_output=TRUE)

adjusted_example <- set_assess_time(data=example_sim,time=10)
}
\author{
James Bell
}
