% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_QQ_unif.R
\name{geom_QQ_unif}
\alias{geom_QQ_unif}
\title{geom_QQ_unif}
\usage{
geom_QQ_unif(mapping = NULL, data = NULL, geom = "point",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  keep_first_n = 1024, step = 8, sorted = FALSE)
}
\arguments{
\item{mapping}{Default list of aesthetic mappings to use for plot. If not specified, must be suppled in each layer added to the plot.}

\item{data}{Default dataset to use for plot. If not already a data.frame, will be converted to one by fortify. If not specified, must be suppled in each layer added to the plot.}

\item{geom}{Specify which geom to plot -- 'point' and 'line' are the two choices that make sense.}

\item{position}{Position adjustment, either as a string, or the result of a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends? NA, the default, includes if any aesthetics are mapped. FALSE never includes, and TRUE always includes.}

\item{inherit.aes}{If FALSE, overrides the default aesthetics, rather than combining with them. This is most useful for helper functions that define both data and aesthetics and shouldn't inherit behaviour from the default plot specification.}

\item{keep_first_n}{Keep the first n p-values (closest to 0).}

\item{step}{How many points to plot with each doubling, e.g. between 1/8 and 1/4, between 1/4 and 1/2, etc.}

\item{sorted}{logical. Are the p-values already sorted?}
}
\value{
a ggplot
}
\description{
geom_QQ_unif
}
\examples{
library(ggplot2)
library(dplyr)

set.seed(27599)
d <- data.frame(s = runif(n = 5e3))

d \%>\%
ggplot(mapping = aes(sample = s)) +
 geom_QQ_unif() +
 scale_x_QQ() +
 scale_y_QQ() +
 theme_minimal()

}
