% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_each_all.R
\name{bind_each_all}
\alias{bind_each_all}
\title{Bind each all.}
\usage{
bind_each_all(
  data,
  ...,
  name = "each_all",
  each = "Each",
  all = "All",
  all_after = Inf
)
}
\arguments{
\item{data}{A data frame or tibble.}

\item{...}{An unquoted variable.}

\item{name}{A variable name. Defaults to \code{each_all}.}

\item{each}{A string for the each value. Defaults to \code{"Each"}.}

\item{all}{A string for the all value. Defaults to \code{"All"}.}

\item{all_after}{A number for where the all value should be placed after. Use \code{0} for first or \code{Inf} for last. Defaults to \code{Inf}.}
}
\value{
A data frame or tibble
}
\description{
Binds data to support plotting each category \emph{and} all combined data.
}
\examples{
library(dplyr)
library(ggplot2)
library(palmerpenguins)

set_blanket()

penguins |>
  distinct(species)

penguins |>
  bind_each_all(species) |>
  distinct(species, each_all)

penguins |>
  bind_each_all(species) |>
  gg_jitter(
    x = species,
    y = body_mass_g,
  )

penguins |>
  bind_each_all(species) |>
  gg_jitter(
    x = species,
    y = body_mass_g,
    col = each_all,
    col_palette = c(blue, grey),
  ) +
  theme(legend.position = "none")

penguins |>
  bind_each_all(species) |>
  group_by(species, each_all) |>
  summarise(across(body_mass_g, \(x) mean(x, na.rm = TRUE))) |>
  gg_col(
    x = species,
    y = body_mass_g,
    col = each_all,
    col_palette = c(blue, grey),
    width = 0.5,
    y_label = "Average body mass g",
  ) +
  theme(legend.position = "none")

penguins |>
  bind_each_all(species, all = "All\nspecies") |>
  gg_jitter(
    x = species,
    y = body_mass_g,
    col = each_all,
    col_palette = c(blue, grey),
    facet = each_all,
    facet_layout = "grid",
    facet_scales = "free_x",
    facet_space = "free_x",
  ) +
  theme(legend.position = "none") +
  theme(strip.text.x = element_blank()) +
  labs(x = NULL)

}
