% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dumbbell_chart.R
\name{dumbbell_chart}
\alias{dumbbell_chart}
\title{Dumbbell Chart}
\usage{
dumbbell_chart(
  data,
  x,
  y1,
  y2,
  line_size = 1.5,
  line_color = "lightgray",
  point_size = 4,
  point_colors = c("#1F77B4", "#FF7F0E"),
  sort = TRUE,
  horizontal = TRUE,
  top_n = NULL,
  legend = TRUE,
  legend_labels = waiver(),
  limit = NULL
)
}
\arguments{
\item{data}{Dataset to use for the dumbbell chart}

\item{x}{\code{character} or \code{factor} column of \code{data}}

\item{y1}{\code{numeric} column of \code{data} representing the dumbbell end}

\item{y2}{\code{numeric} column of \code{data} representing the dumbbell start}

\item{line_size}{\code{numeric}. Line width}

\item{line_color}{\code{character}. Line color}

\item{point_size}{\code{numeric}. Point size}

\item{point_colors}{\code{numeric}. Point color}

\item{sort}{\code{logical}. Should the data be sorted by \code{y2} before
plotting?}

\item{horizontal}{\code{logical}. Should the plot be displayed horizontally?}

\item{top_n}{\code{integer}. If a value for top_n is provided only the first
\code{top_n} records will be displayed}

\item{legend}{\code{logical}. Should a legend be displayed?}

\item{legend_labels}{\code{character}. Custom labels to be displayed in the
legend}

\item{limit}{Deprecated. use \code{top_n} instead.}
}
\value{
An object of class \code{ggplot}
}
\description{
Easily create a dumbbell chart
}
\examples{
data(popeurope)

dumbbell_chart(popeurope, country, pop1952, pop2007)

# Display only the top 10 countries in terms of population in 2007
dumbbell_chart(popeurope, country, pop1952, pop2007, top_n = 10)

# Change line and point color
dumbbell_chart(popeurope, country, pop1952, pop2007, top_n = 10,
               line_color = "lightgray", point_color = c("lightgray", "black"))

# Add custom legend labels
dumbbell_chart(popeurope, country, pop1952, pop2007, top_n = 10,
               legend_labels = c("1952", "2007"))

# Increase line width and point size
dumbbell_chart(popeurope, country, pop1952, pop2007, top_n = 10,
               line_size = 2, point_size = 5)

}
\seealso{
To learn how to further customize this plot have a look at the 'customize' vignette:
\code{vignette("customize", package = "ggcharts")}
}
\author{
Thomas Neitmann
}
