% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_daynight.R
\name{geom_daynight}
\alias{geom_daynight}
\title{Add Day/Night Pattern to ggplot}
\usage{
geom_daynight(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  day_fill = "white",
  night_fill = "grey30",
  sunrise = 6,
  sunset = 18,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{day_fill}{The fill color for daytime rectangles. Defaults to "white".}

\item{night_fill}{The fill color for nighttime rectangles. Defaults to "grey30".}

\item{sunrise}{The hour at which daytime starts. Defaults to 6 (6 AM).}

\item{sunset}{The hour at which nighttime starts. Defaults to 18 (6 PM).}

\item{...}{Additional arguments passed to `geom_rect`.}
}
\value{
A ggplot2 layer representing the day/night pattern.
}
\description{
Adds a day/night pattern to a ggplot object. Daytime is represented by
rectangles filled with the specified `day_fill` color and nighttime by
rectangles filled with the specified `night_fill` color.
The pattern is created along the x-axis, which must be a datetime variable.
}
\examples{
# Basic usage with default parameters
library(ggplot2)
ggplot(daynight_temperature, aes(datetime, temperature)) +
  geom_daynight() +
  geom_point()

# Basic usage with faceting by sensor
ggplot(daynight_temperature, aes(datetime, temperature)) +
  geom_daynight() +
  geom_point() +
  facet_wrap(vars(sensor))

# Usage with lines and color by sensor
ggplot(daynight_temperature, aes(datetime, temperature, color = sensor)) +
  geom_daynight() +
  geom_line()

# Custom day and night fill colors, custom sunrise and sunset times, and adjusted alpha
ggplot(daynight_temperature, aes(datetime, temperature, color = sensor)) +
  geom_daynight(
    day_fill = "yellow", night_fill = "blue",
    sunrise = 5, sunset = 20, alpha = 0.5
  ) +
  geom_line(linewidth = 1)
}
