% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{qw}
\alias{qw}
\alias{qc}
\title{Create a vector from unquoted words.}
\usage{
qw(x)

qc(...)
}
\arguments{
\item{x}{A single string of elements to be split at whitespace chars.}

\item{...}{Unquoted words, separated by comma.}
}
\value{
A vector of quoted words.
}
\description{
Similar to perl's \code{qw()}, however, in R spaces between args in function call
always cause an error, so \verb{qw(foo bar)} wouldn't work. Workaround is either a
single string split at spaces, or unquoted elements, separated by commas.
}
\details{
Took inspiration from
\href{https://stackoverflow.com/questions/520810/does-r-have-quote-like-operators-like-perls-qw}{stackoverflow/qw}
and \href{https://github.com/jebyrnes/multifunc/blob/master/R/qw.R}{github/Jarrett Byrnes}
}
\examples{
qw("foo bar") # with a strsplit
qc(foo, bar) # or unquoted, but with commas
}
\keyword{internal}
