% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_interactive.R
\name{annotate_interactive}
\alias{annotate_interactive}
\title{Create interactive annotations}
\usage{
annotate_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \link{interactive_parameters}.}
}
\description{
The layer is based on \code{\link[ggplot2:annotate]{ggplot2::annotate()}}.
See the documentation for that function for more details.
}
\section{Details for annotate_*_interactive functions}{

The interactive parameters can be supplied as arguments in the relevant function
and they can be scalar values or vectors depending on params on base function.
}

\examples{
# add interactive annotation to a ggplot -------
library(ggplot2)
library(ggiraph)
library(gdtools)

register_liberationsans()

gg <- ggplot(mtcars, aes(x = disp, y = qsec)) +
  geom_point(size = 2) +
  annotate_interactive(
    "rect",
    xmin = 100,
    xmax = 400,
    fill = "red",
    data_id = "an_id",
    tooltip = "a tooltip",
    ymin = 18,
    ymax = 20,
    alpha = .5
  ) +
  theme_minimal(base_family = "Liberation Sans", base_size = 11)

girafe(
  ggobj = gg,
  width_svg = 5,
  height_svg = 4,
  dependencies = list(
    liberationsansHtmlDependency()
  )
)




}
\seealso{
\code{\link[=girafe]{girafe()}}, \link{interactive_parameters}, \code{\link[=annotation_raster_interactive]{annotation_raster_interactive()}}
}
