#' Energy Production Projection Data
#'
#' A dataset containing projected energy production values under different
#' scenarios from 2025 to 2050. The data includes projections for various
#' energy sources.
#'
#' @format A data frame with 24 rows and 7 variables:
#' \describe{
#'   \item{Year}{Integer year of projection (2025-2050)}
#'   \item{Scenario}{Character: High, Low, Moderate, Reference}
#'   \item{Biomass}{Numeric biomass energy proportion}
#'   \item{Coal}{Numeric coal energy proportion}
#'   \item{Electrolysis}{Numeric electrolysis energy proportion}
#'   \item{Gas}{Numeric gas energy proportion}
#'   \item{Nuclear}{Numeric nuclear energy proportion}
#' }
#'
#' @source Data simulated from:\cr
#' Ampah, J.D., Jin, C., Liu, H. et al. (2024) "Deployment expectations
#' of multi-gigatonne scale carbon removal could have adverse impacts on
#' Asia’s energy-water-land nexus" <doi:10.1038/s41467-024-50594-5>
#'
#' @usage data(energy_data)
"energy_data"




#' Relative Synonymous Codon Usage (RSCU) Data
#'
#' A longitudinal dataset documenting codon usage bias patterns across
#' multiple species. Contains normalized RSCU values calculated from protein-
#' coding sequences.
#'
#' @format A tibble with 186 rows and 5 columns:
#' \describe{
#'   \item{AA}{\code{character} Standard three-letter amino acid code with
#'             isotype variants indicating synonymous codon groups: e.g.,
#'             \code{"Phe"}, \code{"Leu1"}, \code{"Leu2"}}
#'   \item{Codon}{\code{character} RNA codon triplet in uppercase:
#'               e.g., \code{"UUU"}, \code{"CUA"}}
#'   \item{Fill}{\code{integer} Group index classifying synonymous codons
#'              for each amino acid (e.g., 1, 2, etc.)}
#'   \item{Species}{\code{character} Organism identifier in
#'                 \code{[Accession].[Version]} format: e.g.,
#'                 \code{"MK693137.1"}}
#'   \item{RSCU}{\code{numeric} Relative Synonymous Codon Usage value}
#' }
#'
#' @source Data derived from previously published studies based on protein-
#' coding sequences analyzed in our laboratory. Accession numbers correspond
#' to NCBI GenBank.
#'
#' @usage data(rscu_data)
"rscu_data"




#' Hydrogen production by technology and scenario (2010–2070)
#'
#' @format A data frame with 27 rows and 8 variables:
#' \describe{
#'   \item{Year}{Year of production}
#'   \item{type}{Production technology (e.g., CG, SMR, EL, BG+CCS, etc.)}
#'   \item{NPI}{Production under the NPI scenario}
#'   \item{C}{Production under the C scenario}
#'   \item{MNET}{Production under the MNET scenario}
#'   \item{gCCS}{Production under the gCCS scenario}
#'   \item{PBIO}{Production under the PBIO scenario}
#'   \item{all}{Production under the all scenario}
#' }
#'
#' @source Data simulated from:\cr
#' Zanon-Zotin, M., Baptista, L.B., Draeger, R. et al. (2024) "Unaddressed
#' non-energy use in the chemical industry can undermine fossil fuels phase-out"
#' <doi:10.1038/s41467-024-52434-y>
#'
#' @usage data(hydrogen_data)
"hydrogen_data"




#' Monthly financial data (income and expenses breakdown)
#'
#' @format A data frame with 66 rows and 4 variables:
#' \describe{
#'   \item{Month}{Month of record (e.g., Jan, Feb)}
#'   \item{Category}{Main category: Income or Expenses}
#'   \item{Subcategory}{Detailed type (e.g., Revenue, COGS, Payroll, R&D)}
#'   \item{Amount}{Amount in local currency}
#' }
#'
#' @source Self-created simulated data.
#'
#' @usage data(financial_data)
"financial_data"




#' Cell Scoring Data
#'
#' Simulated dataset containing normalized immune cell type scores across
#' biological samples with technical replicates.
#'
#' @format A data frame with 207 rows and 5 variables:
#' \describe{
#' \item{Sample}{Character vector indicating sample groups (e.g., "A-CP4-T",
#'   "CP4", "NTC")}
#' \item{Replicate}{Character vector identifying technical replicates
#'   (Rep1-Rep6)}
#' \item{Total_Score}{Numeric total score per replicate for normalization}
#' \item{CellType}{Character vector specifying immune cell types}
#' \item{Score}{Numeric normalized cell type score}
#' }
#'
#' @source Self-created simulated data.
#'
#' @usage data(scoring_data)
"scoring_data"




#' Hominid Genomic Architecture Dataset
#'
#' Region-specific genome size data for six hominid species across two haplotypes.
#'
#' @format Tibble with 62 rows × 4 columns:
#' \describe{
#'   \item{Species}{Species code (PAB, PPY, GGO, HSA, PPA, PTR)}
#'   \item{group}{Haplotype (H1/H2)}
#'   \item{Region}{Genomic region: Euchromatin, Centromere, Acrocentric, QH_region, etc.}
#'   \item{MB}{Region size in megabases}
#' }
#'
#' @source Data simulated from:\cr
#' Yoo, D., Rhie, A., Hebbar, P. et al. (2025) "Complete sequencing of ape genomes"
#' <doi:10.1038/s41586-025-08816-3>
#'
#' @usage data(genomic_data)
"genomic_data"




