<!-- badges: start -->
[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version/ggmix)](https://cran.r-project.org/package=ggmix)
[![AppVeyor build status](https://ci.appveyor.com/api/projects/status/github/sahirbhatnagar/ggmix?branch=master&svg=true)](https://ci.appveyor.com/project/sahirbhatnagar/ggmix)
[![Travis-CI Build Status](https://travis-ci.org/sahirbhatnagar/ggmix.svg?branch=master)](https://travis-ci.org/sahirbhatnagar/ggmix)
[![Coverage status](https://codecov.io/gh/sahirbhatnagar/ggmix/branch/master/graph/badge.svg)](https://codecov.io/github/sahirbhatnagar/ggmix?branch=master)
[![Downloads](https://cranlogs.r-pkg.org/badges/grand-total/ggmix?color=green)](https://www.r-pkg.org/pkg/ggmix)
[![R-CMD-check](https://github.com/sahirbhatnagar/ggmix/workflows/R-CMD-check/badge.svg)](https://github.com/sahirbhatnagar/ggmix/actions)
<!-- badges: end -->

<br>

# ggmix: Simultaneous SNP selection and adjustment for population structure in high dimensional prediction models


## Installation

```r
# stable version from CRAN
install.packages("ggmix")

# development version from GitHub
if (!requireNamespace("pacman")) install.packages("pacman")
pacman::p_load_gh('sahirbhatnagar/ggmix')
```


<br>

## Methodological Details

The companion paper is available at https://journals.plos.org/plosgenetics/article?id=10.1371/journal.pgen.1008766

<br>

## Documentation

Please visit https://sahirbhatnagar.com/ggmix/ for details on how to use this package.   

<br>

Please note that the 'ggmix' project is released with a [Contributor Code of Conduct](https://sahirbhatnagar.com/ggmix/CODE_OF_CONDUCT.html). By contributing to this project, you agree to abide by its terms.

<br>

## References

If you use `ggmix` in your work, I would highly appreciate if you cite the paper and the package:

1. Bhatnagar SR, Yang Y, Lu T, Schurr E, Loredo-Osti JC, Forest M, Oualkacha K, Greenwood CMT (2020). Simultaneous SNP selection and adjustment for population structure in high dimensional prediction models. PLoS Genet 16(5): e1008766. https://doi.org/10.1371/journal.pgen.1008766.

2. Bhatnagar SR, Oualkacha K, Yang Y, Greenwood CMT (2020). ggmix: Variable Selection in Linear Mixed Models for SNP Data. R package version 0.0.2. https://github.com/sahirbhatnagar/ggmix.
