% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette.R
\name{palette_okabe_ito}
\alias{palette_okabe_ito}
\title{Okabe-Ito Palette}
\usage{
palette_okabe_ito(order = 1:9, alpha = NULL, recycle = FALSE)
}
\arguments{
\item{order}{A numeric vector, the order of the colors}

\item{alpha}{an alpha-transparency level in the range [0,1]
    (0 means transparent and 1 means opaque).}

\item{recycle}{logical indicating what happens in case \code{n >
      length(palette(.))}.  By default (\code{recycle = FALSE}), the
    result is as for \code{n = NULL}, but with a warning.}
}
\value{
A character vector of hex codes
}
\description{
\code{palette_okabe_ito()} is a wrapper around \code{palette.colors()} that returns the
Okabe-Ito palette in R 4.0.0 or greater. \code{palette_okabe_ito()} returns an
unnamed vector of colors for better use with ggplot2. Additionally, black is
the last color returned by \code{palette_okabe_ito()} when 9 colors are needed
instead of the first, as in \code{palette.colors()}.
}
\examples{

palette_okabe_ito()

palette_okabe_ito(order = c(2, 3, 5), alpha = 0.9)
}
