% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_arrow.R
\name{scale_arrow}
\alias{scale_arrow}
\title{Scale Arrows to Plot}
\usage{
scale_arrow(arrows, data, at = c(0, 0), fill = 0.75)
}
\arguments{
\item{arrows}{A two column data frame of coordinates from envfit result.}

\item{data}{A two column data frame of coordinates for ordination plot.}

\item{at}{coordinates of origin (0, 0)}

\item{fill}{proportion of plot area to fill with maximum arrow length}
}
\value{
Silently returns a data frame of scaled coordinates for adding arrows to ordination plot.
}
\description{
Scales envfit arrows to fit within 75% of ordination plot dimensions.
}
\examples{
data("varespec")
data("varechem")
vare_dist <- vegdist(varespec)
vare_mds <- monoMDS(vare_dist)
plt1 <- gg_envfit(ord=vare_mds, env=varechem, plot = FALSE)
mult <- scale_arrow(plt1$df_arrows, plt1$df_ord[ , c("x", "y")])
mult

}
\author{
Jari Oksanen with modifications by Gavin Simpson and John Quensen
}
