% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggparty.R
\name{ggparty}
\alias{ggparty}
\title{Create a new ggparty plot}
\usage{
ggparty(
  party,
  horizontal = FALSE,
  terminal_space,
  layout = NULL,
  add_vars = NULL
)
}
\arguments{
\item{party}{Object of class `party`.}

\item{horizontal}{If `TRUE` plot will be horizontal.}

\item{terminal_space}{Proportion of the plot that should be reserved for
the terminal nodeplots. Defaults to `2 / (depth(party) + 2)`.}

\item{layout}{Optional layout adjustment. Overwrites the coordinates of the
specified nodes. Must be `data.frame` containing the
 columns `id`, `x` and `y`. With `x` and `y` values between 0 and 1.}

\item{add_vars}{Named list containing either string(s) specifying the locations
of elements to be extracted from
each node of `party`  or function(s) of corresponding row of plot data and node.
 In either case returned object  has to be of length 1.
 If the data is supposed to be accessible by [geom_node_plot()] the respective
 list entry has
 to be named with the prefix `"nodedata_"` and be a function returning a list
 of same length as `nodesize`.}
}
\description{
`ggplot2` extension for objects of class `party`. Creates a `data.frame` from
an object of class `party` and calls [ggplot2::ggplot()]
}
\details{
`ggparty` can be called directly with an object of class `party`, which will
convert it to a suitable `data.frame` and pass it to a call to `ggplot` with as
the `data` argument. As usual, additional components can then be added with
`+`.

The nodes will be spaced equally in the unit square. Specifying
`terminal_size` allows to increase or decrease the area for plots of the
terminal nodes.

If one of the list entries supplied to `add_vars` is a function, it has to take
 exactly two arguments,
 namely `data` (the corresponding row of the plot_data data frame) and `node`
  (the corresponding node, i.e. `party_object[i]`)
}
\examples{
library(ggparty)
data("WeatherPlay", package = "partykit")
sp_o <- partysplit(1L, index = 1:3)
sp_h <- partysplit(3L, breaks = 75)
sp_w <- partysplit(4L, index = 1:2)
pn <- partynode(1L, split = sp_o, kids = list(
  partynode(2L, split = sp_h, kids = list(
    partynode(3L, info = "yes"),
    partynode(4L, info = "no"))),
  partynode(5L, info = "yes"),
  partynode(6L, split = sp_w, kids = list(
    partynode(7L, info = "yes"),
    partynode(8L, info = "no")))))
py <- party(pn, WeatherPlay)

ggparty(py) +
  geom_edge() +
  geom_edge_label() +
  geom_node_label(aes(label = splitvar),
                  ids = "inner") +
  geom_node_label(aes(label = info),
                  ids = "terminal")
}
\seealso{
[geom_edge()], [geom_edge_label()], [geom_node_label()],
 [autoplot.party()], [geom_node_plot()]
}
