% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_gsea.R
\name{create_network_plot}
\alias{create_network_plot}
\title{Create network visualization of GSEA results}
\usage{
create_network_plot(
  gsea_results,
  similarity_measure = "jaccard",
  similarity_cutoff = 0.3,
  n_pathways = 20,
  layout = "fruchterman",
  node_color_by = "NES",
  edge_width_by = "similarity"
)
}
\arguments{
\item{gsea_results}{A data frame containing GSEA results from the pathway_gsea function}

\item{similarity_measure}{A character string specifying the similarity measure: "jaccard", "overlap", or "correlation"}

\item{similarity_cutoff}{A numeric value specifying the similarity threshold for filtering connections}

\item{n_pathways}{An integer specifying the number of pathways to display}

\item{layout}{A character string specifying the network layout algorithm: "fruchterman", "kamada", or "circle"}

\item{node_color_by}{A character string specifying the node color mapping: "NES", "pvalue", or "p.adjust"}

\item{edge_width_by}{A character string specifying the edge width mapping: "similarity" or "constant"}
}
\value{
A ggplot2 object
}
\description{
Create network visualization of GSEA results
}
\keyword{internal}
