% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-table.R
\name{ttheme_set}
\alias{ttheme_set}
\alias{set_ttheme}
\title{Set default table theme}
\usage{
ttheme_set(table.theme = NULL)

set_ttheme(table.theme = NULL)
}
\arguments{
\item{table.theme}{NULL, list or function A gridExtra ttheme defintion, or
a constructor for a ttheme or NULL for default.}
}
\value{
A named list with the previous value of the option.
}
\description{
Set R option to the theme to use as current default. This function is
implemented differently but is used in the same way as
\code{ggplot2::theme_set()} but affects the default table-theme instead
of the plot theme.
}
\note{
The ttheme is set when a plot object is constructed, and consequently
the option setting does not affect rendering of ready built plot objects.
}
\examples{
library(dplyr)
library(tibble)

mtcars \%>\%
  group_by(cyl) \%>\%
  summarize(wt = mean(wt), mpg = mean(mpg)) \%>\%
  ungroup() \%>\%
  mutate(wt = sprintf("\%.2f", wt),
         mpg = sprintf("\%.1f", mpg)) -> tb

df <- tibble(x = 5.45, y = 34, tb = list(tb))

# Same as the default theme constructor
ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) +
  geom_point() +
  geom_table(data = df, aes(x = x, y = y, label = tb))

# set a new default
old_ttheme <- ttheme_set(ttheme_gtstripes)

ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) +
  geom_point() +
  geom_table(data = df, aes(x = x, y = y, label = tb))

# restore previous setting
ttheme_set(old_ttheme)

}
