% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabD.R
\name{tabD}
\alias{tabD}
\title{Dominance relationship matrix \strong{D} in a tabular-sparse format}
\usage{
tabD(ped, A)
}
\arguments{
\item{ped}{: \code{data.frame} with integer columns corresponding to ID, SIRE, DAM. Missing value is 0.}

\item{A}{: Relationship matrix \strong{A} in a tabular format created by function \code{\link{tabA}}.}
}
\value{
Dominance relationship \code{data.frame}
}
\description{
Creates the pedigree-based dominance relationship \code{data.frame}.
}
\examples{
ped = data.frame(ID=1:6, SIRE=c(0,0,1,3,1,4), DAM=c(0,0,2,2,2,5))
tabD(ped, tabA(ped))

}
