% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal-doc.r, R/scale-shadow.r
\name{scale_brewer}
\alias{scale_brewer}
\alias{scale_shadowcolour_brewer}
\alias{scale_shadowcolour_distiller}
\title{Sequential, diverging and qualitative colour scales from colorbrewer.org}
\usage{
scale_shadowcolour_brewer(
  ...,
  type = "seq",
  palette = 1,
  direction = 1,
  aesthetics = "shadowcolour"
)

scale_shadowcolour_distiller(
  ...,
  type = "seq",
  palette = 1,
  direction = -1,
  values = NULL,
  space = "Lab",
  na.value = "grey50",
  guide = "colourbar",
  aesthetics = "shadowcolour"
)
}
\arguments{
\item{...}{Other arguments passed on to [discrete_scale()], [continuous_scale()],
or [binned_scale()], for `brewer`, `distiller`, and `fermenter` variants
respectively, to control name, limits, breaks, labels and so forth.}

\item{type}{One of "seq" (sequential), "div" (diverging) or "qual"
(qualitative)}

\item{palette}{If a string, will use that named palette. If a number, will index into
the list of palettes of appropriate `type`. The list of available palettes can found
in the Palettes section.}

\item{direction}{Sets the order of colours in the scale. If 1, the default,
colours are as output by \code{\link[RColorBrewer:ColorBrewer]{RColorBrewer::brewer.pal()}}. If -1, the
order of colours is reversed.}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful, for
example, to apply colour settings to the \code{colour} and \code{fill} aesthetics at the
same time, via \code{aesthetics = c("colour", "fill")}.}

\item{values}{if colours should not be evenly positioned along the gradient
this vector gives the position (between 0 and 1) for each colour in the
\code{colours} vector. See \code{\link[scales:rescale]{rescale()}} for a convenience function
to map an arbitrary range to between 0 and 1.}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}

\item{na.value}{Colour to use for missing values}

\item{guide}{Type of legend. Use \code{"colourbar"} for continuous
colour bar, or \code{"legend"} for discrete colour legend.}
}
\value{
a scale object to add to a plot.
}
\description{
The `brewer` scales provides sequential, diverging and qualitative
colour schemes from ColorBrewer. These are particularly well suited to
display discrete values on a map. See \url{https://colorbrewer2.org} for
more information.
}
\details{
The `brewer` scales were carefully designed and tested on discrete data.
They were not designed to be extended to continuous data, but results often
look good. Your mileage may vary.
}
\note{
The `distiller` scales extend brewer to continuous scales by smoothly
interpolating 7 colours from any palette to a continuous scale. The `fermenter`
scales provide binned versions of the brewer scales.
}
\section{Palettes}{

The following palettes are available for use with these scales:
\describe{
  \item{Diverging}{BrBG, PiYG, PRGn, PuOr, RdBu, RdGy, RdYlBu, RdYlGn, Spectral}
  \item{Qualitative}{Accent, Dark2, Paired, Pastel1, Pastel2, Set1, Set2, Set3}
  \item{Sequential}{Blues, BuGn, BuPu, GnBu, Greens, Greys, Oranges,
     OrRd, PuBu, PuBuGn, PuRd, Purples, RdPu, Reds, YlGn, YlGnBu, YlOrBr, YlOrRd}
}
Modify the palette through the `palette` argument.
}

\examples{
library( ggplot2 )
p <- ggplot(mtcars, aes(wt, mpg, shadowcolor=as.factor(gear)))
p + geom_shadowpoint() + scale_shadowcolour_brewer()

library( ggplot2 )
p <- ggplot(mtcars, aes(wt, mpg, shadowcolor=gear))
p + geom_shadowpoint() + scale_shadowcolour_distiller() + guides(shadowcolor='none')

}
\seealso{
Other colour scales: 
\code{\link{scale_colour_hue}},
\code{\link{scale_colour_steps}},
\code{\link{scale_gradient}},
\code{\link{scale_grey}},
\code{\link{scale_viridis}}
}
\concept{colour scales}
