% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barcharts.R
\name{ggbarcrosstabs3d_svy}
\alias{ggbarcrosstabs3d_svy}
\title{Crosstabs of Three Variables Using svy.design object}
\usage{
ggbarcrosstabs3d_svy(surveyobj, x, y, z, fill = NULL, labeller = NULL)
}
\arguments{
\item{surveyobj}{svy.design obj}

\item{x}{bar chart variable}

\item{y}{crosstab variable 1 (horizontal facets)}

\item{z}{crosstab variable 2 (vertical facets)}

\item{fill}{if true the fill of each bar will be a different color corresponding to the level of the factor}

\item{labeller}{argument to pass onto facet_grid}
}
\value{
ggplot object
}
\description{
In ggsurvey you specify both the plotting variables and weights in plain text with no quotes.
}
\examples{
library(survey)
data(api)
dstrat<-svydesign(id=~1,strata=~stype, weights=~pw, data=apistrat, fpc=~fpc)
ggbarcrosstabs3d_svy(dstrat, stype, yr.rnd, awards)
ggbarcrosstabs3d_svy(dstrat, stype, yr.rnd, awards, fill = TRUE)
data(nhanes)
design <- svydesign(id=~SDMVPSU, strata=~SDMVSTRA, weights=~WTMEC2YR, nest=TRUE,data=nhanes)
ggbarcrosstabs3d_svy(design, race, agecat, RIAGENDR)
}
