% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-point-trace.R
\name{geom_point_trace}
\alias{geom_point_trace}
\title{Trace points}
\usage{
geom_point_trace(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  trace_position = "all",
  background_params = list(color = NA),
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{trace_position}{Specifies which data points to outline, can be one of:
\itemize{
  \item "all" to outline every group plotted
  \item "bottom" to only outline the bottom layer of data points
  \item A predicate specifying which data points to outline. This must
        evaluate to \code{TRUE} or \code{FALSE} within the context of the
        input data. e.g. \code{value > 100}
}}

\item{background_params}{Named list specifying aesthetic parameters to use
for background data points when a predicate is passed to
\code{trace_position}, e.g. \code{list(color = "red")}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
ggplot object
}
\description{
This geom is similar to \code{ggplot2::geom_point()}, but also includes the
ability to outline points of interest. \code{geom_point_trace()} accepts
normal ggplot2 graphical parameters with some modifications. \code{fill}
controls the color of each point, \code{color} controls the outline
color, and \code{stroke} controls outline width, similar to how filled
shapes are modified for other ggplot2 geoms. Additional parameters including
\code{size}, \code{linetype}, and \code{alpha} are also accepted.
}
\section{Aesthetics}{

\code{geom_point_trace()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
  \item \strong{\code{x}}
  \item \strong{\code{y}}
  \item \code{alpha}
  \item \code{colour}
  \item \code{fill}
  \item \code{group}
  \item \code{linetype}
  \item \code{shape}
  \item \code{size}
  \item \code{stroke}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}

\examples{
# Modify outline color for each group
ggplot2::ggplot(
  clusters,
  ggplot2::aes(UMAP_1, UMAP_2, color = cluster)
) +
  geom_point_trace() +
  ggplot2::theme_minimal()

# Outline a subset of points
ggplot2::ggplot(
  clusters,
  ggplot2::aes(UMAP_1, UMAP_2, fill = cluster)
) +
  geom_point_trace(trace_position = signal < 0 | signal > 17) +
  ggplot2::theme_minimal()

# Modify appearance of background points
ggplot2::ggplot(
  clusters,
  ggplot2::aes(UMAP_1, UMAP_2, fill = cluster)
) +
  geom_point_trace(
    trace_position    = signal < 0 | signal > 17,
    background_params = list(color = NA, fill = "grey85")
  ) +
  ggplot2::theme_minimal()

}
\seealso{
\link[ggplot2]{geom_point}
}
