#' Subgroup Text Labels for Treemap Bar Charts
#'
#' Add text labels to subgroups of a treemap bar chart generated by
#' [geom_treebar()] or [geom_treecol()].
#'
#' These functions take the same aesthetic mappings as [geom_treebar()] and
#' [geom_treecol()], and are to be used in conjunction with them, ensuring that
#' arguments like `position` match where supplied.
#'
#' @inheritParams geom_treebar
#' @inheritParams ggplot2::geom_text
#' @inheritParams treemapify::geom_treemap_subgroup_text
#' @seealso [geom_treebar()], [geom_treebar_subgroup_border()].
#' @returns A [ggplot2::layer()].
#' @examples
#' library(ggplot2)
#' ggplot(diamonds, aes(y = clarity, fill = cut, subgroup = color)) +
#'   geom_treebar(position = "dodge") +
#'   geom_treebar_subgroup_text(position = "dodge")
#' @export
geom_treebar_subgroup_text <- function(
    mapping = NULL,
    data = NULL,
    stat = "count",
    position = "stack",
    na.rm = FALSE,
    show.legend = FALSE,
    inherit.aes = TRUE,
    padding.x = grid::unit(1, "mm"),
    padding.y = grid::unit(1, "mm"),
    place = "bottom",
    min.size = 4,
    grow = FALSE,
    reflow = FALSE,
    fixed = NULL,
    layout = "squarified",
    start = "bottomleft",
    level = "subgroup",
    ...
) {
  ggplot2::layer(
    data = data,
    mapping = mapping,
    stat = stat,
    geom = GeomTreecolSubgroupText,
    position = position,
    show.legend = show.legend,
    inherit.aes = inherit.aes,
    params = list(
      na.rm = na.rm,
      padding.x = padding.x,
      padding.y = padding.y,
      place = place,
      min.size = min.size,
      grow = grow,
      reflow = reflow,
      fixed = fixed,
      layout = layout,
      start = start,
      level = level,
      ...
    )
  )
}

#' @rdname geom_treebar_subgroup_text
#' @export
geom_treecol_subgroup_text <- function(
    mapping = NULL,
    data = NULL,
    stat = "identity",
    position = "stack",
    na.rm = FALSE,
    show.legend = FALSE,
    inherit.aes = TRUE,
    padding.x = grid::unit(1, "mm"),
    padding.y = grid::unit(1, "mm"),
    place = "bottom",
    min.size = 4,
    grow = FALSE,
    reflow = FALSE,
    fixed = NULL,
    layout = "squarified",
    start = "bottomleft",
    level = "subgroup",
    ...
) {
  ggplot2::layer(
    data = data,
    mapping = mapping,
    stat = stat,
    geom = GeomTreecolSubgroupText,
    position = position,
    show.legend = show.legend,
    inherit.aes = inherit.aes,
    params = list(
      na.rm = na.rm,
      padding.x = padding.x,
      padding.y = padding.y,
      place = place,
      min.size = min.size,
      grow = grow,
      reflow = reflow,
      fixed = fixed,
      layout = layout,
      start = start,
      level = level,
      ...
    )
  )
}


#' @rdname geom_treebar_subgroup_text
#' @export
geom_treebar_subgroup2_text <- function(...) {
  geom_treebar_subgroup_text(level = "subgroup2", ...)
}

#' @rdname geom_treebar_subgroup_text
#' @export
geom_treecol_subgroup2_text <- function(...) {
  geom_treecol_subgroup_text(level = "subgroup2", ...)
}

#' @rdname geom_treebar_subgroup_text
#' @export
geom_treebar_subgroup3_text <- function(...) {
  geom_treebar_subgroup_text(level = "subgroup3", ...)
}

#' @rdname geom_treebar_subgroup_text
#' @export
geom_treecol_subgroup3_text <- function(...) {
  geom_treecol_subgroup_text(level = "subgroup3", ...)
}
