% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gist_create_obj.R
\name{gist_create_obj}
\alias{gist_create_obj}
\title{Create a gist from an R object}
\usage{
gist_create_obj(
  x = NULL,
  description = "",
  public = TRUE,
  browse = TRUE,
  pretty = TRUE,
  filename = "file.txt",
  ...
)
}
\arguments{
\item{x}{An R object, any of data.frame, matrix, list, character, numeric}

\item{description}{(character) Brief description of gist (optional)}

\item{public}{(logical) Whether gist is public (default: \code{TRUE})}

\item{browse}{(logical) To open newly create gist in default browser
(default: \code{TRUE})}

\item{pretty}{(logical) For data.frame and matrix objects, create
a markdown table. If FALSE, pushes up json. (default: \code{TRUE})}

\item{filename}{Name of the file to create. Default: \code{file.txt}}

\item{...}{Further args passed on to \link[crul:verb-POST]{crul::verb-POST}}
}
\description{
Create a gist from an R object
}
\details{
This function is specifically for going from R objects to a gist,
whereas \code{\link[=gist_create]{gist_create()}} is for going from files or executing code
}
\examples{
\dontrun{
## data.frame
### by default makes pretty table in markdown format
row.names(mtcars) <- NULL
gist_create_obj(mtcars)
gist_create_obj(iris)
### or just push up json
gist_create_obj(mtcars, pretty = FALSE)

## matrix
gist_create_obj(as.matrix(mtcars))
## list
gist_create_obj(apply(mtcars, 1, as.list))
## character
gist_create_obj("hello, world")
## numeric
gist_create_obj(runif(10))

## Assign a specific file name
gist_create_obj("
## header2

hey there!", filename = "my_markdown.md")
}
}
\seealso{
\code{\link[=gist_create]{gist_create()}}, \code{\link[=gist_create_git]{gist_create_git()}}
}
