# tests/testthat/test-emforbeta.R

library(testthat)
library(glmfitmiss)  # Load your package

# Load example data for glm.fit
data("est45", package = "glmfitmiss")
print("Debug: Structure of est45")
# print(str(est45))

# Load the expected cvcov matrix for glm.fit from the data folder
#load(system.file("data", "expected_cvcovglmforbeta.RData", package = "glmFitMiss"))

# Define other expected values for glm.fit (these would be precomputed for the specific test case)
# expected_beta <- c(`(Intercept)` = -3.85535341, Fetoprtn = -0.16438673, Antigen = 0.15221442, Jaundice = -0.79215934, Age = 0.06511526)
# expected_alpha <- c(0.3065370, 0.1163299, 0.3362203, 0.2409127)

# Test that emforbeta works correctly with glm.fit
test_that("emforbeta returns the correct structure and values with glm.fit", {

  # Fit the model with the vcorctn argument
  f_fit <- emforbeta(resp ~ Fetoprtn + Antigen + Jaundice + Age, data = est45, family = binomial, vcorctn = TRUE, method = "glm.fit")
  expect_snapshot({
    print(f_fit$beta)
    print(f_fit$alpha)
    print(f_fit$cvcov)
  })

  # Test that the result is a list
  expect_type(f_fit, "list")

  # Test that the list contains the expected elements
  expect_true("beta" %in% names(f_fit))
  expect_true("alpha" %in% names(f_fit))
  expect_true("wgt" %in% names(f_fit))
  expect_true("fitem" %in% names(f_fit))
  expect_true("converged" %in% names(f_fit))
  expect_true("cvcov" %in% names(f_fit))

  # Test that beta is a named numeric vector
  expect_type(f_fit$beta, "double")
  expect_true(is.numeric(f_fit$beta))
  expect_true(!is.null(names(f_fit$beta)))
  # Check numerical accuracy of beta
  # expect_equal(f_fit$beta, expected_beta, tolerance = 1e-5)

  # Test that alpha is numeric (assuming it's a vector)
  expect_type(f_fit$alpha, "double")
  # Check numerical accuracy of alpha
  # e†xpect_equal(f_fit$alpha, expected_alpha, tolerance = 1e-5)

  # Test that wgt is a numeric vector
  expect_type(f_fit$wgt, "double")
  # Add numerical checks for wgt if expected values are known

  # Test that fitem is a numeric vector
  expect_type(f_fit$fitem, "double")
  # Add numerical checks for fitem if expected values are known

  # Test that converged is a logical value
  expect_type(f_fit$converged, "logical")
  # Add specific checks for converged if expected value is known

  # Test that mfit is a glm object (assuming it is)
  expect_s3_class(f_fit$mfit, "glm")

  # Test that cvcov is a matrix
  expect_true(is.matrix(f_fit$cvcov))
  # Check numerical accuracy of cvcov
  # expect_equal(f_fit$cvcov, expected_cvcov, tolerance = 1e-5)

  # Additional tests can be added based on expected values or properties
  expect_equal(length(f_fit$beta), 5)  # Adjust the expected length based on your model
})

# Optionally, test summary of glm fit
test_that("summary of glm fit works correctly", {
  f_fit <- emforbeta(resp ~ Fetoprtn + Antigen + Jaundice+ Age, data = est45, family = binomial, vcorctn = TRUE, method = "glm.fit")
  glm_summary <- summary(f_fit$mfit)

  # Test that the summary has the expected structure
  expect_s3_class(glm_summary, "summary.glm")

  # Additional checks on the summary content can be added here
})

# Test that emforbeta works correctly with brglmFit
test_that("emforbeta returns the correct structure and values with brglmFit", {
  # Skip this test if brglm2 is not installed
  skip_if_not_installed("brglm2")

  # Load example data for the brglmFit test
  data("meningitis", package = "glmfitmiss")
  print("Debug: Structure of meningitis")
  # print(str(meningitis))

  # Fit the model with the brglmFit method
  f_fit1 <- emforbeta(CaseCntrl ~ Numnill + Numsleep + Smoke + Set+ Reftime, data = meningitis, vcorctn = TRUE, family = "binomial", method = "brglmFit")

  expect_snapshot({
    print(f_fit1$beta)
    print(f_fit1$alpha)
    print(f_fit1$cvcov)
  })

  # Test that the result is a list
  expect_type(f_fit1, "list")

  # Test that the list contains the expected elements
  expect_true("beta" %in% names(f_fit1))
  expect_true("alpha" %in% names(f_fit1))
  expect_true("wgt" %in% names(f_fit1))
  expect_true("fitem" %in% names(f_fit1))
  expect_true("converged" %in% names(f_fit1))
  expect_true("finalData" %in% names(f_fit1))
  expect_true("mfit" %in% names(f_fit1))
  expect_true("cvcov" %in% names(f_fit1))

  # Test that beta is a named numeric vector
  expect_type(f_fit1$beta, "double")
  expect_true(is.numeric(f_fit1$beta))
  expect_true(!is.null(names(f_fit1$beta)))

  # Test that alpha is numeric (assuming it's a vector)
  expect_type(f_fit1$alpha, "double")
  expect_true(is.numeric(f_fit1$alpha))

  # Test that wgt is a numeric vector
  expect_type(f_fit1$wgt, "double")
  # Add numerical checks for wgt if expected values are known

  # Test that fitem is a numeric vector
  expect_type(f_fit1$fitem, "double")
  # Add numerical checks for fitem if expected values are known

  # Test that converged is a logical value
  expect_type(f_fit1$converged, "logical")
  # Add specific checks for converged if expected value is known

  # Test that finalData is a data frame
  expect_true(is.data.frame(f_fit1$finalData))

  # Test that mfit is a glm object (assuming it is)
  expect_s3_class(f_fit1$mfit, "glm")

  # Test that cvcov is a matrix
  expect_true(is.matrix(f_fit1$cvcov))
})
