% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_glm_family.r
\name{detect_glm_family}
\alias{detect_glm_family}
\title{Automatically Recommend an Appropriate GLM Family}
\usage{
detect_glm_family(y, plot = TRUE, aic_test = FALSE)
}
\arguments{
\item{y}{A numeric vector representing the response variable.}

\item{plot}{Logical; if \code{TRUE}, a histogram and boxplot of \code{y} will be drawn. Default is \code{TRUE}.}

\item{aic_test}{Logical; if \code{TRUE}, a simple AIC comparison across candidate GLM families will be performed. Default is \code{FALSE}.}
}
\value{
A list containing:
\item{family}{Suggested GLM family}
\item{link}{Suggested link function}
}
\description{
This function assists users in selecting an appropriate \code{family} and link function
for generalized linear models (GLM) based on the distributional properties of the response variable.
It provides a quick diagnostic summary, distribution plots, and an optional AIC comparison among candidate models.
}
\details{
The function inspects the basic characteristics of the response variable, including its range, mean,
variance, and whether it contains only integers or proportions. Based on these diagnostics, it suggests
one or more candidate GLM families among:
\itemize{
  \item \code{"gaussian"} – continuous response, may include negative values
  \item \code{"poisson"} or \code{"quasipoisson"} – integer count data (possibly overdispersed)
  \item \code{"Gamma"} or \code{"inverse.gaussian"} – strictly positive continuous data
  \item \code{"binomial"} – proportion or binary data (0–1 range)
}

The suggested link functions are: \code{"identity"} for Gaussian, \code{"log"} for Poisson/Gamma,
and \code{"logit"} for Binomial.
}
\examples{
# Example 1: Continuous response (can be negative)
set.seed(123)
y1 <- rnorm(100)
detect_glm_family(y1)

# Example 2: Count data
y2 <- rpois(100, lambda = 5)
detect_glm_family(y2)

# Example 3: Proportion data
y3 <- rbeta(100, 2, 5)
detect_glm_family(y3)

}
