% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv-glmmsel.R
\name{cv.glmmsel}
\alias{cv.glmmsel}
\title{Cross-validated generalised linear mixed model selection}
\usage{
cv.glmmsel(
  x,
  y,
  cluster,
  family = c("gaussian", "binomial"),
  lambda = NULL,
  nfold = 10,
  folds = NULL,
  cv.loss = NULL,
  interpolate = TRUE,
  ...
)
}
\arguments{
\item{x}{a predictor matrix}

\item{y}{a response vector}

\item{cluster}{a vector of length \code{nrow(x)} with the jth element identifying the cluster
that the jth observation belongs to}

\item{family}{the likelihood family to use; 'gaussian' for a continuous response or 'binomial'
for a binary response}

\item{lambda}{the regularisation parameter for the overlapping penalty on the fixed and random
slopes}

\item{nfold}{the number of cross-validation folds}

\item{folds}{an optional vector of length \code{nrow(x)} with the jth entry identifying the fold
that the jth observation belongs to}

\item{cv.loss}{an optional cross-validation loss-function to use; should accept a vector of
predicted values and a vector of actual values}

\item{interpolate}{a logical indicating whether to interpolate the \code{lambda} sequence for
the cross-validation fits}

\item{...}{any other arguments for \code{glmmsel()}}
}
\value{
An object of class \code{cv.glmmsel}; a list with the following components:
\item{cv.mean}{a vector of cross-validation means}
\item{cv.sd}{a vector of cross-validation standard errors}
\item{lambda}{a vector of cross-validated regularisation parameters}
\item{lambda.min}{the value of \code{lambda} minimising \code{cv.mean}}
\item{fit}{the fit from running \code{glmmsel()} on the full data}
}
\description{
Fits the regularisation path for a sparse generalised linear mixed model and then
cross-validates this path.
}
\examples{
# Generate data
set.seed(1234)
n <- 100
m <- 4
p <- 10
s <- 5
x <- matrix(rnorm(n * p), n, p)
beta <- c(rep(1, s), rep(0, p - s))
u <- cbind(matrix(rnorm(m * s), m, s), matrix(0, m, p - s))
cluster <- sample(1:m, n, replace = TRUE)
xb <- rowSums(x * sweep(u, 2, beta, '+')[cluster, ])
y <- rnorm(n, xb)

# Fit sparse linear mixed model
fit <- cv.glmmsel(x, y, cluster)
plot(fit)
fixef(fit)
ranef(fit)
coef(fit)
predict(fit, x[1:3, ], cluster[1:3])
}
\references{
Thompson, R., Wand, M. P., and Wang, J. J. J. (2025). 'Scalable subset selection in
linear mixed models'. arXiv: \href{https://arxiv.org/abs/2506.20425}{2506.20425}.
}
\author{
Ryan Thompson <ryan.thompson-1@uts.edu.au>
}
