% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.permu.R
\name{permu}
\alias{permu}
\title{Permutation Function}
\usage{
permu(variables, family, npermu = 1000, CI.percent = 0.95)
}
\arguments{
\item{variables}{a data frame of all the variables.}

\item{family}{a description of the error distribution and link function to be used in the model.}

\item{npermu}{the number of permutation times. The default value is 1000.}

\item{CI.percent}{the confidence level. The default value is 0.95.}
}
\value{
a vector.
}
\description{
In practical applications, the assumptions underlying generalized linear models frequently face violations, including incorrect specifications of the outcome variable's distribution or omitted predictors. These deviations can render the results of standard generalized linear models unreliable. As the sample size increases, what might initially appear as minor issues can escalate to critical concerns. To address these challenges, we adopt a permutation-based inference method tailored for generalized linear models. This approach offers robust estimations that effectively counteract the mentioned problems, and its effectiveness remains consistent regardless of the sample size.
}
