% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glossary_options.R
\name{glossary_path}
\alias{glossary_path}
\title{Set or get the default glossary path}
\usage{
glossary_path(path, create = FALSE)
}
\arguments{
\item{path}{the path to the glossary file, or NULL for local definitions}

\item{create}{create a new glossary file if it doesn't exist}
}
\value{
path string if path is NULL
}
\description{
Set or get the default glossary path
}
\examples{
path <- glossary_path() # get current path

# create (if doesn't exist) and set path
newpath <- tempfile("glossary", fileext = ".yml")
glossary_path(newpath, create = TRUE)

# set path (assumes file exists)
glossary_path(path)
}
