% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_gls_batch.R
\name{calibrate_gls_batch}
\alias{calibrate_gls_batch}
\title{Batch Calibration of Multiple GLS Devices}
\usage{
calibrate_gls_batch(
  data_dir,
  output_dir,
  colony_lat,
  colony_lon,
  light_threshold = 2,
  exclude_equinoxes = NULL,
  min_positions = 10,
  create_plots = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{data_dir}{Character path to directory containing .lux files}

\item{output_dir}{Character path for output files}

\item{colony_lat}{Numeric latitude of colony/capture location}

\item{colony_lon}{Numeric longitude of colony/capture location}

\item{light_threshold}{Numeric light threshold in lux (default: 2)}

\item{exclude_equinoxes}{List of date ranges to exclude (optional)}

\item{min_positions}{Minimum number of valid positions required (default: 10)}

\item{create_plots}{Logical, whether to create diagnostic plots (default: TRUE)}

\item{verbose}{Logical, print progress messages (default: TRUE)}
}
\value{
A list containing:
  \item{summary}{data.frame with calibration summary for all birds}
  \item{results}{List of position estimates for each bird}
  \item{processing_log}{Detailed processing log}
}
\description{
Main function for automated batch processing of GLS data. Auto-discovers
all birds in a directory, detects calibration periods, performs an internal
gamma-style sun elevation calibration, and generates standardized outputs.
}
\details{
This function implements a complete automated workflow:
\enumerate{
  \item Auto-discovers .lux files in the data directory
  \item For each bird:
    \itemize{
      \item Reads light data
      \item Auto-detects calibration period
      \item Detects and filters twilights
      \item Learns a sun elevation angle directly from the calibration data
      \item Calculates positions using threshold method
      \item Generates diagnostic plots
    }
  \item Combines results into standardized formats
  \item Creates summary statistics and quality control metrics
}
}
\examples{
\donttest{
example_dir <- file.path(tempdir(), "gls_example_data")
dir.create(example_dir, showWarnings = FALSE)
file.copy(
  system.file("extdata/W086_24May17_215116.lux", package = "glscalibrator"),
  file.path(example_dir, "W086_24May17_215116.lux"),
  overwrite = TRUE
)

results <- calibrate_gls_batch(
  data_dir = example_dir,
  output_dir = file.path(tempdir(), "gls_example_output"),
  colony_lat = 27.85178,
  colony_lon = -115.17390,
  min_positions = 1,
  create_plots = FALSE,
  verbose = FALSE
)

equinoxes <- list(
  c("2024-08-24", "2024-10-23"),
  c("2024-02-19", "2024-04-19")
)
results_filtered <- calibrate_gls_batch(
  data_dir = example_dir,
  output_dir = file.path(tempdir(), "gls_example_output"),
  colony_lat = 27.85,
  colony_lon = -115.17,
  exclude_equinoxes = equinoxes,
  min_positions = 1,
  create_plots = FALSE,
  verbose = FALSE
)
}

}
