% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resid_fit.R
\name{resid_fit}
\alias{resid_fit}
\title{Residual fit indices}
\usage{
resid_fit(
  S = NULL,
  Sigma = NULL,
  ybar = NULL,
  mu = NULL,
  lavaan_object = NULL,
  exo = TRUE
)
}
\arguments{
\item{S}{sample covariance matrix}

\item{Sigma}{model-implied covariance matrix}

\item{ybar}{sample mean vector}

\item{mu}{model-implied mean vector}

\item{lavaan_object}{is a fitted model of class \code{lavaan}}

\item{exo}{boolean argument indicating if model has exogenous covariates}
}
\value{
An S4 object
}
\description{
Computes the RMR, SRMR, and CRMR.
}
\section{Details}{

\code{S}, \code{Sigma}, \code{ybar}, and \code{mu} must be of the same dimensions.

If the sum of the diagonal elements of \code{S} equals the sum of the diagonal elements of \code{Sigma}
the variance component of SRMR is not included

If the sum of the sample means \code{yhat} equals the sum of the model-implied means \code{mu}
the mean component of SRMR is not included
}

\examples{
Sigma <- matrix(c(1.022, .550,  .622, .550, .928, .783, .622, .783, 1.150), 
                    nrow = 3)
S <- matrix(c(.770, .545, .515, .545, 1.003, .890, .515, .890, 1.211), 
            nrow = 3)
ybar <- c(2.516, 4.041, 5.021)
mu <- c(2.825, 3.877, 4.929)

resid_fit(S = S,  Sigma = Sigma, ybar = ybar, mu = mu)

}
