% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-iupac-extended.R
\name{parse_iupac_extended}
\alias{parse_iupac_extended}
\title{Parse IUPAC-extended Structures}
\usage{
parse_iupac_extended(x)
}
\arguments{
\item{x}{A character vector of IUPAC-extended strings.}
}
\value{
A \code{\link[glyrepr:glycan_structure]{glyrepr::glycan_structure()}} object.
}
\description{
Parse IUPAC-extended-style structure characters into a \code{\link[glyrepr:glycan_structure]{glyrepr::glycan_structure()}}.
For more information about IUPAC-extended format, see \doi{10.1351/pac199668101919}.
}
\examples{
iupac <- "\u03b2-D-Galp-(1\u21923)-\u03b1-D-GalpNAc-(1\u2192"
parse_iupac_extended(iupac)

}
\seealso{
\code{\link[=parse_iupac_condensed]{parse_iupac_condensed()}}, \code{\link[=parse_iupac_short]{parse_iupac_short()}}
}
