% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-clef-.R
\name{Clef}
\alias{Clef}
\title{Create \code{Clef} Object}
\usage{
Clef(sign, line = NULL, octave = NULL, to = NULL, bar = NULL, offset = NULL)
}
\arguments{
\item{sign}{A single character, which can be \code{"G"}, \code{"F"} or \code{"C"}.
Case insensitive.}

\item{line}{Optional. A single integer, which depends on \code{sign}:
\itemize{
\item \code{1} or \code{2}, if \code{sign} is \code{"G"};
\item an integer between \code{3} and \code{5}, if \code{sign} is \code{"F"};
\item an integer between \code{1} and \code{5}, if \code{sign} is \code{"C"}.
}}

\item{octave}{Optional. A single integer, which can be \code{-1} or \code{1}.
\code{octave} can be specified only when
\itemize{
\item \code{sign} is \code{"G"} and \code{line} is \code{2}, or
\item \code{sign} is \code{"F"} and \code{line} is \code{4}.
}}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the clef.}

\item{bar}{Optional. A positive integer, which indicates the number of
the measure where to add the clef. By default, the clef will be added at
the first measure.}

\item{offset}{Optional. A non-negative number,
which indicates the clef's position in a measure. The default value is \code{0}.}
}
\value{
A list of class \code{Clef}.
}
\description{
Create a \code{Clef} object to represent a clef.
}
\details{
See \href{https://en.wikipedia.org/wiki/Clef}{Wikipedia} for more details.
}
\examples{
# Create a bass clef
clef <- Clef("F")
clef

# Add the clef to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C3", "D3")) + clef
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a \code{Clef} to a \code{Music} object.
}
