% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2-add-music.R
\name{+.Music}
\alias{+.Music}
\title{Add Component to \code{Music} Object}
\usage{
\method{+}{Music}(music, object)
}
\arguments{
\item{music}{A \code{Music} object.}

\item{object}{An object of class \code{Line}, \code{Meter}, \code{Key}, \code{Tempo}, \code{Clef}, \code{Instrument}, \code{Pedal}, \code{Slur}, \code{Hairpin}, \code{Notehead}, \code{Accidental}, \code{Velocity}, \code{Dynamic}, \code{Grace}, \code{Stem}, \code{Lyric}, \code{Tie}, \code{Articulation}, \code{Fermata}, \code{Breath}, \code{Trill}, \code{Turn}, \code{Mordent}, \code{Schleifer} or \code{Tremolo}.}
}
\value{
A list of class \code{Music}.
}
\description{
Add a component to a \code{Music} object.
}
\examples{
# Initialize a `Music` object
music <- Music()

# Add a `Line`
music <- music + Line("C4", 1)
music

# Add a `Meter`
music <- music + Meter(4, 4)
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=Music]{Music()}} for initialization of a \code{Music} object.
}
