% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_auth.R
\name{gm_token_write}
\alias{gm_token_write}
\alias{gm_token_read}
\title{Write/read a gmailr user token}
\usage{
gm_token_write(token = gm_token(), path = "gmailr-token.rds", key = NULL)

gm_token_read(path = "gmailr-token.rds", key = NULL)
}
\arguments{
\item{token}{A token with class \link[httr:Token-class]{Token2.0} or an object of
httr's class \code{request}, i.e. a token that has been prepared with
\code{\link[httr:config]{httr::config()}} and has a \link[httr:Token-class]{Token2.0} in the
\code{auth_token} component.}

\item{path}{The path to write to (\code{gm_token_write()}) or to read from
(\code{gm_token_read()}).}

\item{key}{Encryption key, as implemented by httr2's \href{https://httr2.r-lib.org/reference/secrets.html}{secret functions}. If absent, a
built-in \code{key} is used. If supplied, the \code{key} should usually be the name
of an environment variable whose value was generated with
\code{gargle::secret_make_key()} (which is a copy of
\code{httr2::secret_make_key()}). The \code{key} argument of \code{gm_token_read()} must
match the \code{key} used in \code{gm_token_write()}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This pair of functions writes an OAuth2 user token to file and reads it back
in. This is rarely necessary when working in your primary, interactive
computing environment. In that setting, it is recommended to lean into the
automatic token caching built-in to gmailr / gargle. However, when preparing
a user token for use elsewhere, such as in CI or in a deployed data product,
it can be useful to take the full control granted by \code{gm_token_write()} and
\code{gm_token_read()}.

Below is an outline of the intended workflow, but you will need to fill in
particulars, such as filepaths and environment variables:
\itemize{
\item Do auth in your primary, interactive environment as the target user, with
the desired OAuth client and scopes.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gm_auth_configure()
gm_auth("jane@example.com", cache = FALSE)
}\if{html}{\out{</div>}}
\item Confirm you are logged in as the intended user:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gm_profile()
}\if{html}{\out{</div>}}
\item Write the current token to file:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gm_token_write(
  path = "path/to/gmailr-token.rds",
  key = "GMAILR_KEY"
)
}\if{html}{\out{</div>}}
\item In the deployed, non-interactive setting, read the token from file and
tell gmailr to use it:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gm_auth(token = gm_token_read(
  path = "path/to/gmailr-token.rds",
  key = "GMAILR_KEY"
)
}\if{html}{\out{</div>}}
}
}
\section{Security}{

\code{gm_token_write()} and \code{gm_token_read()} have a more security-oriented
implementation than the default token caching strategy. OAuth2 user tokens
are somewhat opaque by definition, because they aren't written to file in a
particularly transparent format. However, \code{gm_token_write()} always applies
some additional obfuscation to make such credentials even more resilient
against scraping by an automated tool. However, a knowledgeable R programmer
could decode the credential with some effort. The default behaviour of
\code{gm_token_write()} (called without \code{key}) is suitable for tokens stored in a
relatively secure place, such as on Posit Connect within your organization.

To prepare a stored credential for exposure in a more public setting, such as
on GitHub or CRAN, you must actually encrypt it, using a \code{key} known only to
you. You must make the encryption \code{key} available via a secure environment
variable in any setting where you wish to decrypt and use the token, such as
on GitHub Actions.
}

