% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{gmfamm_predict}
\alias{gmfamm_predict}
\title{Prediction of Generalized Multivariate Functional Additive Mixed model}
\usage{
gmfamm_predict(
  object,
  newdata,
  model = NULL,
  term = NULL,
  match.names = TRUE,
  intercept = TRUE,
  type = c("link", "parameter"),
  compress = TRUE,
  FUN = function(x) {
     mean(x, na.rm = TRUE)
 },
  trans = NULL,
  what = c("samples", "parameters"),
  nsamps = NULL,
  verbose = FALSE,
  drop = TRUE,
  cores = NULL,
  chunks = 1,
  ...
)
}
\arguments{
\item{object}{bamlss-model object to be predicted.}

\item{newdata}{Dataset for which to create predictions. Not needed for
conditional survival probabilities.}

\item{model}{Character or integer, specifies the model for which predictions should be computed.}

\item{term}{Character or integer, specifies the model terms for which predictions are required.
    Note that, e.g., \code{term = c("s(x1)", "x2")} will compute the combined prediction
    \code{s(x1) + x2}.}

\item{match.names}{Should partial string matching be used to select the \code{term}s for
    prediction. Note that, e.g., \code{term = "x1"} will select all terms including \code{"x1"} if
    \code{match.names = TRUE}.}

\item{intercept}{Should the intercept be included?}

\item{type}{Character string indicating which type of predictions to compute.
\code{link} returns the predictors of the corresponding model., \code{"parameter"} returns the estimates for all
pedictors, \code{"probabilities"} returns the survival probabilities
conditional on the survival up to the last longitudinal measurement, and
\code{"cumhaz"} return the cumulative hazard up to the survival time or for
a time window after the last longitudinal measurement. If \code{type} is
set to \code{"loglik"}, the log-likelihood of the joint model is returned.
Note that types \code{"probabilities"} and \code{"cumhaz"} are not yet
implemented.}

\item{compress}{TRUE if the}

\item{FUN}{A function that should be applied on the samples of predictors or
parameters, depending on argument \code{type}.}

\item{trans}{A transformer function or named list of transformer functions that computes
    transformed predictions. If \code{trans} is a list, the list names must match the names
    of the parameters of the \code{\link[bamlss]{bamlss.family}}.}

\item{what}{Predictions can be computed from samples or estimated parameters of optimizer
    functions. If no samples are available the default is to use estimated parameters.}

\item{nsamps}{If the fitted \code{\link[bamlss]{bamlss}} object contains samples of parameters,
    computing predictions may take quite some time. Therefore, to get a first feeling it can
    be useful to compute predictions only based on \code{nsamps} samples, i.e., \code{nsamps}
    specifies the number of samples which are extracted on equidistant intervals.}

\item{verbose}{Print information during runtime of the algorithm.}

\item{drop}{If predictions for only one \code{model} are returned, the list structure is dropped.}

\item{cores}{Specifies the number of cores that should be used for
prediction. Note that this functionality is based on the
\code{\link[parallel]{parallel}} package.}

\item{chunks}{Should computations be split into \code{chunks}? Prediction is
then processed sequentially.}

\item{...}{Currently not used.}
}
\description{
Note: FPC basis has to be evaluated for newdata before the predict function.
}
\details{
Functionality of some arguments are restricted.
}
