#' Gaussian mixture graphical model learning and inference
#'
#' This package provides a complete framework to deal with Gaussian mixture
#' graphical models, which covers Bayesian networks and dynamic Bayesian
#' networks (their temporal extension) whose local probability distributions are
#' described by Gaussian mixture models. It includes a wide range of functions
#' for:
#' \itemize{
#' \item creating or modifying the structure of Gaussian mixture models
#' (\code{\link{add_var}}, \code{\link{gmm}}, \code{\link{merge_comp}},
#' \code{\link{remove_var}}, \code{\link{rename_var}}, \code{\link{reorder}},
#' \code{\link{split_comp}}) or graphical models (\code{\link{add_arcs}},
#' \code{\link{add_nodes}}, \code{\link{gmbn}}, \code{\link{gmdbn}},
#' \code{\link{relevant}}, \code{\link{remove_arcs}},
#' \code{\link{remove_nodes}}, \code{\link{rename_nodes}});
#' \item describing or visualizing Gaussian mixture models
#' (\code{\link{conditional}}, \code{\link{ellipses}},
#' \code{\link{summary.gmm}}) or graphical models (\code{\link{network}},
#' \code{\link{structure}}, \code{\link{summary.gmbn}},
#' \code{\link{summary.gmdbn}});
#' \item computing densities, expectations, or sampling Gaussian mixture models
#' (\code{\link{density}}, \code{\link{expectation}}, \code{\link{sampling}});
#' \item computing scores of Gaussian mixture models (\code{\link{AIC.gmm}},
#' \code{\link{BIC.gmm}}, \code{\link{logLik.gmm}}) or graphical models
#' (\code{\link{AIC.gmbn}}, \code{\link{AIC.gmdbn}}, \code{\link{BIC.gmbn}},
#' \code{\link{BIC.gmdbn}}, \code{\link{logLik.gmbn}},
#' \code{\link{logLik.gmdbn}});
#' \item learning the structure and/or the parameters of Gaussian mixture models
#' (\code{\link{em}}, \code{\link{smem}}, \code{\link{stepwise}}) or graphical
#' models (\code{\link{param_em}}, \code{\link{param_learn}},
#' \code{\link{struct_em}}, \code{\link{struct_learn}});
#' \item performing inference in Gaussian mixture graphical models
#' (\code{\link{aggregation}}, \code{\link{filtering}}, \code{\link{inference}},
#' \code{\link{particles}}, \code{\link{prediction}}, \code{\link{propagation}},
#' \code{\link{smoothing}}).
#' }
#' Descriptions of these functions are provided in this manual with related
#' references. Most of the algorithms are described in the PhD thesis of Roos
#' (2018, in french). To better handle this package, two real-world datasets are
#' provided (\code{\link{data_air}}, \code{\link{data_body}}) with examples of
#' Gaussian mixture models and graphical models (\code{\link{gmbn_body}},
#' \code{\link{gmdbn_air}}, \code{\link{gmm_body}}).
#'
#' @references
#' Roos, J. (2018). \emph{\ifelse{html}{\out{Pr&eacute;vision a court terme des
#' flux de voyageurs : une approche par les r&eacute;seaux
#' bay&eacute;siens}}{Prévision a court terme des flux de voyageurs : une
#' approche par les réseaux bayésiens}}. PhD thesis, University of Lyon.
#'
#' @docType package
#' @name gmgm-package
#'
#' @import dplyr
#' @import ggplot2
#' @import purrr
#' @import stringr
#' @import tidyr
#' @import visNetwork
#' @importFrom rlang :=
#' @importFrom stats AIC BIC logLik na.omit rnorm runif

NULL

globalVariables(c(".", "comp", "from", "from_lag", "from_new", "movable", "to",
                  "var_x", "var_y", "where"))
