% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnomonic-main.R
\name{gnomonic}
\alias{gnomonic}
\title{Gnomonic deterministic}
\usage{
gnomonic(
  nInterval,
  eggDuration,
  addInfo = NULL,
  longevity,
  fecundity,
  a_init = 2
)
}
\arguments{
\item{nInterval}{a numeric value that represents the number of gnomonic intervals.}

\item{eggDuration}{a numeric value with the egg stage (first gnomonic interval) duration in days.}

\item{addInfo}{a numeric vector with additional information related to the observed duration of the other gnomonic intervals different than the first interval (egg stage duration). Write \code{addInfo = NULL} if you do not provide additional information.}

\item{longevity}{a numeric value indicating the lifespan of the species in days.}

\item{fecundity}{a numeric value indicating the mean lifetime fecundity (MLF) as the number of eggs produced for a female.}

\item{a_init}{a numeric value indicating the initial parameter related to the proportionality  optimized by iterative solution via univariate (1-dim.) minimization. \code{a_init = 2} as default value.}
}
\value{
A list of class 'gnomos'.

\code{a} the proportionality constant.

\code{G} the constant proportion of the overall natural death rate.

\code{results} a dataframe with the duration ("interval_duration_day") and natural mortality ("M_day" and "M_year") for each gnomonic interval.
}
\description{
Estimate natural mortality based on gnomonic interval approach.
}
\details{
Estimate natural mortality (M) based on gnomonic interval approach.

The argument \code{nInterval} is NULL by default. If you have -at least- one observed value for the duration of the other gnomonic intervals
you should provide this as a vector which length must be nInterval - 1, for example \code{addInfo = c(3, NA, NA, NA, NA, NA)}) for a \code{nInterval = 7}.
}
\examples{
#The values are based on Caddy (1996).
model <- gnomonic(nInterval = 7, eggDuration = 2, addInfo = NULL,
longevity = 365, fecundity = 200000, a_init = 2)

model
model$a
model$G
model$results

#Additional information for the duration of the second gnomonic intervals.
model <- gnomonic(nInterval = 7, eggDuration = 2, addInfo = c(3, NA, NA, NA, NA, NA),
longevity = 365, fecundity = 200000, a_init = 2)

model
model$a
model$G
model$results
}
\references{
Caddy JF (1996). Modelling natural mortality with age in short-lived invertebrate populations: definition of a strategy of gnomonic time division. Aquat Living Resour 9:197–207. doi: 10.1051/alr:1996023.
}
