% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnomonicStochastic.R
\name{gnomonicStochastic}
\alias{gnomonicStochastic}
\title{Gnomonic stochastic}
\usage{
gnomonicStochastic(
  nInterval,
  eggDuration,
  addInfo = NULL,
  longevity,
  fecundity = NULL,
  sd_fecundity = NULL,
  min_fecundity = NULL,
  max_fecundity = NULL,
  distr = "uniform",
  a_init = 2,
  niter = 999,
  seed = 7388
)
}
\arguments{
\item{nInterval}{a numeric value that represents the number of gnomonic intervals.}

\item{eggDuration}{a numeric value with the egg stage (first gnomonic interval) duration in days.}

\item{addInfo}{a numeric vector with additional information related to the observed duration of the other gnomonic intervals different than the first interval (egg stage duration). Write \code{addInfo = NULL} if you do not provide additional information.}

\item{longevity}{a numeric value indicating the lifespan of the species in days.}

\item{fecundity}{a numeric value indicating the mean or the mode of the fecundity as the number of eggs produced for a female if a normal or triangular distribution is assumed, respectively.}

\item{sd_fecundity}{a numeric value indicating the standard deviation of fecundity if a normal distribution is assumed.}

\item{min_fecundity}{a numeric value indicating the minimum range of fecundity if a uniform or triangle distribution is assumed.}

\item{max_fecundity}{a numeric value indicating the maximum range of fecundity if a uniform or triangle distribution is assumed.}

\item{distr}{a character string indicating the distribution to be applied: \code{"uniform"}, \code{"triangle"} or \code{"normal"}}

\item{a_init}{a numeric value indicating the initial parameter related to the proportionality constant optimized by iterative solution via univariate (1-dim.) minimization. \code{a_init = 2} as default value.}

\item{niter}{a single numeric value representing the number of iterations.}

\item{seed}{a single value, interpreted as an integer.}
}
\value{
A list of class 'gnomosBoot'.

\code{a} the proportionality constant.

\code{G} the 'n' iter values of constant proportion of the overall natural death rate.

\code{mean_G} the mean of constant proportion of the overall natural death rate,

\code{M} a dataframe with the M values for each gnomonic intervals for each 'n' iteration.

\code{fecundity} the 'n' iter values of fecundity based on the distribution assumed.

\code{results} a dataframe with the duration ("interval_duration_day"), mean, confidence interval and standard deviation of natural mortality ("M_lower", "M", "M_upper", "M_sd") for each gnomonic interval.
}
\description{
Estimate natural mortality based on gnomonic interval approach with different distribution in fecundity.
}
\details{
Estimate natural mortality (M) based on gnomonic interval approach .

The argument \code{nInterval} is NULL by default. If you have -at least- one observed value for the duration of the other gnomonic intervals
you should provide this as a vector which length must be nInterval - 1, for example \code{addInfo = c(3, NA, NA, NA, NA, NA)}) for a \code{nInterval = 7}.

The argument \code{fecundity} requires a character string indicating the name of the distribution of fecundity values to be used in the
analysis (i.e. \code{fecundity = "uniform"}).

The argument \code{niter} requires a number which is related with the number of observations. If length(n) > 1, the length is taken to be the number required.
can be calculated from each bootstrap sample (median and confidence intervals).
}
\examples{
#The values are based on Caddy (1996).
modelBoot <- gnomonicStochastic(nInterval = 7, eggDuration = 2, addInfo = NULL, longevity = 365,
distr = "uniform", min_fecundity = 100000, max_fecundity = 300000, niter = 999, a_init = 2)

# 'niter' parameters:
modelBoot$a
modelBoot$G
modelBoot$mean_G
modelBoot$M
modelBoot$fecundity
modelBoot$results
}
