% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{gofigr_client}
\alias{gofigr_client}
\title{Creates and configures a GoFigr client. You can login either using
a username & password or an API key. See examples.}
\usage{
gofigr_client(
  username = NULL,
  password = NULL,
  api_key = NULL,
  url = NULL,
  anonymous = FALSE,
  verbose = FALSE,
  workspace = NULL,
  ignore_config = FALSE
)
}
\arguments{
\item{username}{username (if not using API key)}

\item{password}{password (if not using API key)}

\item{api_key}{API key (if not using password authentication)}

\item{url}{API URL (optional, you generally won't want to modify this)}

\item{anonymous}{whether to login anonymously}

\item{verbose}{set to TRUE to enable verbose output}

\item{workspace}{default workspace (API ID)}

\item{ignore_config}{if TRUE, will ignore environment variables and other
external configuration}
}
\value{
configured GoFigr client which you can pass to other functions
}
\description{
Username, password, API key and workspace are read from the GoFigr
configuration file (~/.gofigr) or environment variables if not supplied:
}
\details{
* GF_USERNAME or config$username
* GF_PASSWORD or config$password
* GF_API_KEY or config$api_key
* GF_WORKSPACE of config$workspace
* GF_URL or config$url
}
\examples{
\dontrun{gofigr_client()  # use config from ~/.gofigr or environment variables}
\dontrun{gofigr_client(username="joe", password="abc123") # password login}
\dontrun{gofigr_client(api_key="abcdef0123456789") # API key login}
}
