% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_shiny_templates.R
\name{ga_model_shiny}
\alias{ga_model_shiny}
\title{Create a Shiny app from a ga_model file}
\usage{
ga_model_shiny(
  models,
  template = ga_model_shiny_template("basic"),
  header_boilerplate = TRUE,
  title = "ga_model_shiny",
  auth_dropdown = c("ga4", "universal", "none"),
  web_json = Sys.getenv("GAR_CLIENT_WEB_JSON"),
  date_range = TRUE,
  scopes = "https://www.googleapis.com/auth/analytics.readonly",
  deployed_url = "",
  local_folder = "",
  ...
)
}
\arguments{
\item{models}{The \link{ga_model} file location ("my_model.gamr") or a \link{ga_model} object - can pass in multiple as a list}

\item{template}{The template Shiny files for the Shiny app - passed to \code{shiny::runApp()}}

\item{header_boilerplate}{Whether to add header boilerplate to the template}

\item{title}{The title of the Shiny app}

\item{auth_dropdown}{What type of account picker to include}

\item{web_json}{The client.id json file for Web}

\item{date_range}{Most templates support a \{\{ date_range \}\} global input for the data import functions, set this to FALSE to remove it}

\item{scopes}{The scope the API requests will be under}

\item{deployed_url}{If deploying Shiny app to a server, put the URL of the deployed app here so the authentication will redirect to the correct place}

\item{local_folder}{If not empty, will not launch Shiny app but write code to the folder location you put here}

\item{...}{Extra macro variables the template may support: a named list with the name being a template variable}
}
\description{
Create a Shiny app from a ga_model file
}
\details{
As \link{ga_model} objects have standardised code, they can be used to build standard templated Shiny apps.  Templates are made using the \link[whisker:whisker.render]{whisker.render} function

Some templates are included with the package, seen via \code{ga_model_shiny_template("list")}

Templates hold macro variables indicated via \code{ \{\{ macro_name \}\} } in the Shiny app template code. See \code{ga_model_shiny_template("basic_app", TRUE)} for an example showing a minimal viable app.  Templates can be files such as ui.R or app.R files; folders containing ui.R, app.R files; or ui.R with html files for advanced themes - see \href{https://shiny.rstudio.com/articles/templates.html}{Shiny HTML templates}. All additional files that may be in the folder are also copied over (such as global.R or www/ folders)

Templates contain code to allow multi-user login via Google OAuth2.

If your template is pointing at a file such as ui.R or app.R it will create an app.R Shiny object.  If your template is pointing at a directory it will check for the presence of ui.R within the folder.  In either case if the server.R is missing it will use the boilerplate version from \code{ga_model_shiny_template("boilerplate")}

By default the Shiny app is launched which in most cases will prompt authorisation for your Google Analytics.  You can instead write the app out using \code{local_folder} to a valid location for deployment later.
}
\section{Template macro variables}{


\itemize{
\item{\code{\{\{\{ model_libraries \}\}\}} - Adds \code{library()} calls based on models$required_packages}
\item{\code{\{\{\{ web_json \}\}\}} - Adds Google OAuth2 client for web applications}
\item{\code{\{\{\{ scopes \}\}\}} - Adds Google OAuth2 scopes for the API calls}
\item{\code{\{\{\{ deployed_url \}\}\}} - Adds \code{option(googleAuthR.redirect)} option for deployed Shiny apps}
\item{\code{\{\{\{ model_load \}\}\}} - Adds \link{ga_model_load} calls loading all models in the list passed to this function's \code{models} argument.  It creates R objects called 'model1', 'model2' etc. in the Shiny app code}
\item{\code{\{\{\{ model_list \}\}\}} - Adds a list of the model objects after model_load.  Useful for creating custom functions in themes that can loop over model objects}
\item{\code{\{\{\{ shiny_title \}\}\}} - Adds the title to the Shiny app}
\item{\code{\{\{\{ auth_ui \}\}\}} - Adds the correct dropdown Shiny module for picking a GA4 or Universal Analytics properties}
\item{\code{\{\{\{ date_range \}\}\}} - Adds a \code{shiny::dateInput()} date selector with id "date_range" for use in model's data fetching functions}
\item{\code{\{\{\{ model_ui \}\}\}} - Adds the models UI elements as configured in the \link{ga_model} object.  It uses the object loaded above via the model_load macro.  It looks like \code{model1$ui('model1')} in the code.}
\item{\code{\{\{\{ auth_server \}\}\}} - Adds the authentication module's server side function}
\item{\code{\{\{\{ auth_accounts \}\}\}} - Adds a call to \link{ga_account_list} for the appropriate GA account type (GA4 or Universal)}
\item{\code{\{\{\{ model_server \}\}\}} - Adds the server side module for the models as configured in the \link{ga_model} configuration. It uses the object loaded above via the model_load macro.  It looks like \code{model1$server('model1')} in the code.}
\item{\code{\{\{\{ model1 \}\}\}} - Alternative to \code{model_load}, this will load the model file location instead, which you can pass to \code{ga_model_load()}} in the template.  model1 is the first model passed, model2 the second, etc.
\item{\code{\{\{\{ your_argument \}\}\}} - You can pass in your own custom variables to the template via the \code{...} argument of this function if they are named the same as the template macro variable}
}
}

\examples{

# see Shiny templates included with the package
ga_model_shiny_template("list")

# see an example of an ui.R template with macros
ga_model_shiny_template("basic/ui.R", read_lines = TRUE)

# see an example of an app.R template with macros
ga_model_shiny_template("basic_app/app.R", read_lines = TRUE)

\dontrun{

# a universal analytics model using default template "basic"
ga_model_shiny(
  ga_model_example("decomp_ga.gamr"), 
  auth_dropdown = "universal")

# a template from a directory holding an app.R file
ga_model_shiny(
  ga_model_example("decomp_ga.gamr"), 
  auth_dropdown = "universal",
  template = ga_model_shiny_template("basic_app"))
  
  
# a template from only an ui.R file that will import boilerplate server.R
ga_model_shiny(
  ga_model_example("decomp_ga.gamr"), 
  auth_dropdown = "universal",
  template = ga_model_shiny_template("basic/ui.R"))

# a template from a custom html based theme
ga_model_shiny(
  ga_model_example("decomp_ga.gamr"), 
  auth_dropdown = "universal",
  template = ga_model_shiny_template("html_based"))

# a template using library(argonDash)
ga_model_shiny(
  ga_model_example("ga-effect.gamr"), 
  title = "Argon Demo",
  auth_dropdown = "universal",
  template = ga_model_shiny_template("argonDash") )

# multiple models
m3 <- ga_model_example("time-normalised.gamr")
m4 <- ga_model_example("ga-effect.gamr")

# launch in gentelella template
ga_model_shiny(list(m4, m3), auth_dropdown = "universal",
              template = ga_model_shiny_template("gentelella"))

     
# you can make custom ui embedded within the template file
# use \{\{\{ model_list \}\}\} to work with the models in the ui.R

# below adds custom macro 'theme' and a custom ui in box tabs
ga_model_shiny(list(m4, m3), auth_dropdown = "universal", 
               template = ga_model_shiny_template("shinythemes"), 
               theme = "yeti")

# shinydashboard's custom ui functions put a model in each side tab      
ga_model_shiny(list(m4, m3), auth_dropdown = "universal", 
               template = ga_model_shiny_template("shinydashboard"), 
               skin = "green")
               
# send in lots of theme variables to bslib in shiny > 1.6.0
ga_model_shiny(list(m4, m3), auth_dropdown = "universal",
               template = ga_model_shiny_template("basic_bslib"), 
               bg = "white", fg = "red", primary = "grey")
 
# write out an app to a local folder
ga_model_shiny(list(m4, m3), auth_dropdown = "universal",
               template = ga_model_shiny_template("basic_bslib"), 
               bg = "white", fg = "red", primary = "grey",
               local_folder = "deploy_shiny")
}



}
\seealso{
Other GA modelling functions: 
\code{\link{ga_model}()},
\code{\link{ga_model_edit}()},
\code{\link{ga_model_example}()},
\code{\link{ga_model_load}()},
\code{\link{ga_model_make}()},
\code{\link{ga_model_save}()},
\code{\link{ga_model_shiny_load}()},
\code{\link{ga_model_shiny_template}()},
\code{\link{ga_model_write}()}
}
\concept{GA modelling functions}
