% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buckets.R
\name{gcs_delete_bucket}
\alias{gcs_delete_bucket}
\alias{gcs_delete_bucket_objects}
\title{Delete a bucket}
\usage{
gcs_delete_bucket(
  bucket,
  ifMetagenerationMatch = NULL,
  ifMetagenerationNotMatch = NULL,
  force_delete = FALSE
)

gcs_delete_bucket_objects(bucket, include_versions = FALSE)
}
\arguments{
\item{bucket}{Name of the bucket, or a bucket object}

\item{ifMetagenerationMatch}{Delete only if metageneration matches}

\item{ifMetagenerationNotMatch}{Delete only if metageneration does not match}

\item{force_delete}{If the bucket contains objects it will prevent deletion, including objects in a versioned bucket that previously existed.  Setting this to TRUE will force deletion of those objects before deleting the bucket itself.}

\item{include_versions}{Whether to include all historic versions of the objects to delete}
}
\description{
Delete the bucket, and all its objects
}
\seealso{
\link{gcs_delete_object}

Other bucket functions: 
\code{\link{gcs_create_bucket}()},
\code{\link{gcs_create_lifecycle}()},
\code{\link{gcs_get_bucket}()},
\code{\link{gcs_get_global_bucket}()},
\code{\link{gcs_global_bucket}()},
\code{\link{gcs_list_buckets}()}
}
\concept{bucket functions}
