% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate.R
\name{gl_translate_detect}
\alias{gl_translate_detect}
\title{Detect the language of text within a request}
\usage{
gl_translate_detect(string)
}
\arguments{
\item{string}{Character vector of text to detect language for}
}
\value{
A tibble of the detected languages with columns \code{confidence}, \code{isReliable}, \code{language}, and \code{text}, of length equal to the vector of text you passed in.
}
\description{
Detect the language of text within a request
}
\details{
Consider using \code{library(cld2)} and \code{cld2::detect_language} instead for offline detection,
since that is free and does not require an API call.

\link{gl_translate} also returns a detection of the language, so you could optionally use that in one step.
}
\examples{
\dontrun{
gl_translate_detect("katten sidder på måtten")
}
}
\seealso{
\url{https://cloud.google.com/translate/docs/reference/detect}

Other translations: 
\code{\link{gl_translate}()},
\code{\link{gl_translate_document}()},
\code{\link{gl_translate_languages}()}
}
\concept{translations}
