% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_layer_geojson.R
\name{update_geojson}
\alias{update_geojson}
\title{update geojson}
\usage{
update_geojson(map, layer_id = NULL, style)
}
\arguments{
\item{map}{a googleway map object created from \code{google_map()}}

\item{layer_id}{single value specifying an id for the layer.}

\item{style}{Style options for the geoJSON. See details}
}
\description{
Updates a geojson layer by a specified style. Designed to work within an interactive
environment (e.g. shiny)
}
\details{
The style object can either be a valid JSON string, or a named list.
The style object will contain the following fields

\itemize{
\item{property : the property of the geoJSON that contains the \code{value}}
\item{value : the value of the geoJSON that identifies the feature to be updated}
\item{features : a list (or JSON object) of features to be updated}
}

see \link{add_geojson} for valid features
}
\examples{
\dontrun{

style <- paste0('{
    "property" : "AREASQKM",
    "value" : 5,
    "operator" : ">=",
    "features" : {
      "fillColor" : "red",
      "strokeColor" : "red"
    }
  }')

google_map(key = map_key) \%>\%
    add_geojson(data = geo_melbourne) \%>\%
    update_geojson(style = style)

lst_style <- list(property = "AREASQKM", operator = "<=", value = 5,
   features = list(fillColor = "red",
   strokeColor = "red"))

google_map(key = map_key) \%>\%
    add_geojson(data = geo_melbourne) \%>\%
    update_geojson(style = lst_style)

## Styling a specific feature
style <- '{"property" : "SA2_NAME", "value" : "Abbotsford", "features" : { "fillColor" : "red" } }'
google_map(key = map_key) \%>\%
  add_geojson(data = geo_melbourne) \%>\%
  update_geojson(style = style)

}

}
